package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public class SdfContentSigner implements ContentSigner {

    private SdfContentOutputStream stream;
    private AlgorithmIdentifier algorithmIdentifier;

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey) throws SdfSDKException {
        this.algorithmIdentifier = algorithmIdentifier;
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm())) {
            asymmetricKeyParameter = new SdfRSAKeyParameters(privateKey);
        } else if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equals(algorithmIdentifier.getAlgorithm().getId())) {
            asymmetricKeyParameter = new SdfECKeyParameters(privateKey);
        } else {
            throw new SdfSDKException("UnSupport algorithmIdentifier: " + algorithmIdentifier.getAlgorithm().getId());
        }
        this.stream = new SdfContentOutputStream(sdfCryptoType, algorithmIdentifier, true, asymmetricKeyParameter);
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public byte[] getSignature() {
        try {
            return this.stream.getSignature();
        } catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}
