package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public class SdfContentVerifier implements ContentVerifier {

    private SdfContentOutputStream stream;

    public SdfContentVerifier(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws SdfSDKException {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm())) {
            asymmetricKeyParameter = new SdfRSAKeyParameters((RSAPublicKey) publicKey);
        } else if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equals(algorithmIdentifier.getAlgorithm().getId())) {
            asymmetricKeyParameter = new SdfECKeyParameters((ECPublicKey) publicKey);
        }else {
            throw new SdfSDKException("UnSupport algorithmIdentifier: " + algorithmIdentifier.getAlgorithm().getId());
        }
        this.stream = new SdfContentOutputStream(sdfCryptoType, algorithmIdentifier, false, asymmetricKeyParameter);
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public boolean verify(byte[] expected) {
        try {
            return this.stream.verify(expected);
        } catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining verify: " + e.getMessage(), e);
        }
    }
}
