package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;

import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

public class SdfContentVerifierProvider implements ContentVerifierProvider {


    private SdfCryptoType sdfCryptoType;
    private PublicKey publicKey;

    public SdfContentVerifierProvider(SdfCryptoType sdfCryptoType, PublicKey publicKey) {
        this.sdfCryptoType = sdfCryptoType;
        this.publicKey = publicKey;
    }

    @Override
    public boolean hasAssociatedCertificate() {
        return false;
    }

    @Override
    public X509CertificateHolder getAssociatedCertificate() {
        return null;
    }

    @Override
    public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
        try {
            return new SdfContentVerifier(sdfCryptoType, verifierAlgorithmIdentifier, publicKey);
        } catch (SdfSDKException e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }
}
