package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class SdfSM3Digest extends SdfBaseDigest {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final int DIGEST_LENGTH = 32;
    private static final int BYTE_LENGTH = 64;

    private SdfECCPublicKey publicKey;
    private byte[] pucID;

    public SdfSM3Digest() throws SdfSDKException {
        super();
    }

    public SdfSM3Digest(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType);
    }

    public SdfSM3Digest(SdfSDK sdfSDK) throws SdfSDKException {
        super(sdfSDK);
    }

    public SdfSM3Digest(SdfCryptoType sdfCryptoType, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), pucID, publicKey);
    }

    public SdfSM3Digest(SdfSDK sdfSDK, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        super(sdfSDK);
        this.pucID = pucID;
        this.publicKey = publicKey;
    }

    public SdfSM3Digest(SdfSM3Digest t) throws SdfSDKException {
        this.publicKey = t.publicKey;
        this.pucID = t.pucID;
        copyIn(t);
    }

    @Override
    protected void init() throws SdfSDKException {
        if (this.publicKey != null && this.pucID != null) {
            this.sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3, pucID, publicKey);
        } else {
            this.sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SM3";
    }

    @Override
    public int getDigestSize() {
        return DIGEST_LENGTH;
    }

    @Override
    public int getByteLength() {
        return BYTE_LENGTH;
    }

    @Override
    public Memoable copy() {
        try {
            return new SdfSM3Digest(this);
        } catch (SdfSDKException e) {
            logger.error("Memoable copy", e);
            return null;
        }
    }


    @Override
    public void reset(Memoable other) {
        SdfSM3Digest d = (SdfSM3Digest) other;
        try {
            copyIn(d);
            d.releaseConnection();
        } catch (SdfSDKException e) {
            logger.error("reset copy in error", e);
        }
    }
}
