package com.xdja.pki.gmssl.crypto.sdf;


import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;

/**
 * @author sxy
 * @description
 * @date 2020年03月06日 10:02
 **/
public enum SdfAeadType {

    // block 128bit 16Byte
    AES_CCM_128(NISTObjectIdentifiers.id_aes128_CCM, "AES_CCM_128"),
    // block 196bit 24Byte
    AES_CCM_192(NISTObjectIdentifiers.id_aes192_CCM, "AES_CCM_192"),
    // block 256bit 32Byte
    AES_CCM_256(NISTObjectIdentifiers.id_aes256_CCM, "AES_CCM_256");


    private ASN1ObjectIdentifier aid;

    private String name;

    SdfAeadType(ASN1ObjectIdentifier aid, String name) {
        this.aid = aid;
        this.name = name;
    }

    public ASN1ObjectIdentifier getAid() {
        return aid;
    }

    public String getName() {
        return name;
    }

    public static SdfAeadType convertSdfAeadType(ASN1ObjectIdentifier aid) {
        if (NISTObjectIdentifiers.id_aes128_CCM.getId().equalsIgnoreCase(aid.getId())) {
            return AES_CCM_128;
        } else if (NISTObjectIdentifiers.id_aes192_CCM.getId().equalsIgnoreCase(aid.getId())) {
            return AES_CCM_192;
        } else {
            // (NISTObjectIdentifiers.id_aes256_CCM.getId().equalsIgnoreCase(aid.getId()))
            return AES_CCM_256;
        }
    }

    public static SdfAeadType convertSdfAeadType(String algorithm) {
        if (AES_CCM_128.name.equalsIgnoreCase(algorithm)) {
            return AES_CCM_128;
        } else if (AES_CCM_192.name.equalsIgnoreCase(algorithm)) {
            return AES_CCM_192;
        } else {
            return AES_CCM_256;
        }
    }

    public static boolean checkSupportType(ASN1ObjectIdentifier aid) {
        return SdfAeadType.AES_CCM_128.getAid().getId().equalsIgnoreCase(aid.getId())
                || SdfAeadType.AES_CCM_192.getAid().getId().equalsIgnoreCase(aid.getId())
                || SdfAeadType.AES_CCM_256.getAid().getId().equalsIgnoreCase(aid.getId());
    }

}
