package com.xdja.pki.gmssl.crypto.sdf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.bouncycastle.asn1.*;

import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Enumeration;

public class SdfPrivateKey implements PrivateKey {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private int index;
    private byte[] password;

    public static SdfPrivateKey getInstance(Object o) {
        if (o instanceof SdfPrivateKey) {
            return (SdfPrivateKey) o;
        } else if (o instanceof SecretKeySpec) {
            return new SdfPrivateKey(ASN1Sequence.getInstance(((SecretKeySpec) o).getEncoded()));
        } else if (o != null) {
            return new SdfPrivateKey(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public SdfPrivateKey(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        index = ASN1Integer.getInstance(e.nextElement()).getValue().intValue();
        password = DEROctetString.getInstance(e.nextElement()).getOctets();
        logger.debug("SdfPrivateKey index " + index + " password " + new String(password));
    }

    public SdfPrivateKey(int index, byte[] password) {
        this.index = index;
        this.password = password;
    }

    public SdfPrivateKey(int index) {
        this.index = index;
        this.password = "xdja1234".getBytes();
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public byte[] getPassword() {
        return password;
    }

    public String getStringPassword() {
        return new String(password);
    }

    @Override
    public String getAlgorithm() {
        return "SDF-PRIVATE";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        ASN1Integer index = new ASN1Integer(this.index);
        ASN1OctetString password = new DEROctetString(this.password);

        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(index);
        vector.add(password);

        ASN1Sequence sequence = new DERSequence(vector);
        try {
            return sequence.getEncoded();
        } catch (IOException e) {
            logger.error("sequence getEncoded", e);
        }
        return null;
    }

    @Override
    public void destroy() throws DestroyFailedException {

    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    @Override
    public String toString() {
        return "SdfPrivateKey{ " +
                "index=" + index +
                ", password=" + new String(password) +
                " }";
    }
}
