package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import org.bouncycastle.crypto.ExtendedDigest;

public class SdfECSigner extends SdfECBaseSigner {

    public SdfECSigner() throws SdfSDKException {
        super();
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK());
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
    }

    @Override
    public void initDigest(byte[] userID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        digest = new SdfSM3Digest(sdfSDK, userID, sdfECCPublicKey);
    }

    @Override
    public void initDigest(String signAlgName) throws SdfSDKException {
        if (signAlgName.toUpperCase().contains("SHA256")) {
            digest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA256);
        } else if (signAlgName.toUpperCase().contains("SHA1")) {
            digest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA1);
        } else {
            throw new SdfSDKException("unSupport signAlg " + signAlgName);
        }
    }
}
