package com.xdja.pki.gmssl.crypto.sdf;


import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.interfaces.RSAPublicKey;

/**
 * @ClassName SdfRSAKeyParameters
 * @Description TODO
 * @Date 2019/9/12 15:24
 * @Author FengZhen
 */
public class SdfRSAKeyParameters extends AsymmetricKeyParameter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private RSAPublicKey publicKey;
    private SdfPrivateKey privateKey;

    /**
     * for
     * 1. rsa engine encrypt
     * 2. rsa signer verify
     *
     * @param publicKey public key
     */
    public SdfRSAKeyParameters(RSAPublicKey publicKey) {
        super(false);
        this.publicKey = publicKey;
    }

    /**
     * for
     * 1. sm2 engine decrypt
     * 2. sm2 signer sign
     *
     * @param privateKey private key with sdf index and password
     */
    public SdfRSAKeyParameters(SdfPrivateKey privateKey) {
        super(true);
        this.privateKey = privateKey;
    }

    public int getPrivateKeyIndex() {
        return this.privateKey.getIndex();
    }

    public RSAPublicKey getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public SdfPrivateKey getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(SdfPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] getPassword() {
        return this.privateKey.getPassword();
    }
}
