/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfECEngine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfECKeyParameters ecKey;
    private boolean forEncryption;
    private SdfSDK sdfSDK;
    private String stdName;

    public SdfECEngine() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfECEngine(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfECEngine(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public SdfECEngine(SdfSDK sdfSDK, String stdName) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.stdName = stdName;
        this.sdfSDK.init();
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        this.ecKey = (SdfECKeyParameters)param;
    }

    public byte[] encryptASN1(byte[] data) {
        try {
            SdfECCPublicKey sdfECCPublicKey = this.ecKey.getSDFECCPublicKey();
            SdfECCCipher eccCipher = null == this.stdName ? this.sdfSDK.externalEncryptECC(sdfECCPublicKey, data) : this.sdfSDK.externalEncryptECC(sdfECCPublicKey, data, this.stdName);
            ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(eccCipher.getX(), eccCipher.getY(), eccCipher.getM(), eccCipher.getC());
            return asn1SM2Cipher.toASN1Primitive().getEncoded();
        }
        catch (SdfSDKException | IOException e) {
            this.logger.error("encrypt asn1", e);
            return new byte[0];
        }
    }

    public byte[] decryptASN1(byte[] cipher) {
        ASN1SM2Cipher sm2CipherASN1 = ASN1SM2Cipher.getInstance((Object)cipher);
        try {
            assert (sm2CipherASN1 != null);
            SdfECCCipher eccCipher = new SdfECCCipher(GMSSLByteArrayUtils.changeByteArrayLength((byte[])sm2CipherASN1.getxCoordinate().toByteArray(), (int)32), GMSSLByteArrayUtils.changeByteArrayLength((byte[])sm2CipherASN1.getyCoordinate().toByteArray(), (int)32), GMSSLByteArrayUtils.changeByteArrayLength((byte[])sm2CipherASN1.getHash(), (int)32), sm2CipherASN1.getCipherText().length, sm2CipherASN1.getCipherText());
            if (null == this.stdName) {
                return this.sdfSDK.internalDecryptECC(this.ecKey.getEcIndex(), this.ecKey.getPassword(), sm2CipherASN1.getCipherText().length, eccCipher);
            }
            return this.sdfSDK.internalDecryptECC(this.ecKey.getEcIndex(), this.ecKey.getPassword(), sm2CipherASN1.getCipherText().length, eccCipher, this.stdName);
        }
        catch (SdfSDKException e) {
            this.logger.error("decrypt asn1", (Throwable)e);
            return new byte[0];
        }
    }

    public byte[] processBlockASN1(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] data = new byte[inLen];
        System.arraycopy(in, inOff, data, 0, inLen);
        if (this.forEncryption) {
            return this.encryptASN1(data);
        }
        return this.decryptASN1(data);
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] data = new byte[inLen];
        System.arraycopy(in, inOff, data, 0, inLen);
        if (this.forEncryption) {
            return this.encrypt(data);
        }
        return this.decrypt(data);
    }

    public byte[] encrypt(byte[] data) {
        byte[] cipher = null;
        SdfECCPublicKey sdfECCPublicKey = this.ecKey.getSDFECCPublicKey();
        try {
            SdfECCCipher eccCipher = null == this.stdName ? this.sdfSDK.externalEncryptECC(sdfECCPublicKey, data) : this.sdfSDK.externalEncryptECC(sdfECCPublicKey, data, this.stdName);
            byte[] x = eccCipher.getX();
            byte[] y = eccCipher.getY();
            byte[] c = eccCipher.getC();
            byte[] m = eccCipher.getM();
            byte[] PO = new byte[x.length + y.length + 1];
            PO[0] = 4;
            System.arraycopy(x, 0, PO, 1, x.length);
            System.arraycopy(y, 0, PO, x.length + 1, y.length);
            cipher = new byte[PO.length + c.length + m.length];
            System.arraycopy(PO, 0, cipher, 0, PO.length);
            System.arraycopy(c, 0, cipher, PO.length, c.length);
            System.arraycopy(m, 0, cipher, PO.length + c.length, m.length);
            return cipher;
        }
        catch (SdfSDKException e) {
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt x", (byte[])sdfECCPublicKey.getX(), (boolean)true);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt y", (byte[])sdfECCPublicKey.getY(), (boolean)true);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt data", (byte[])data, (boolean)true);
            this.logger.error("encrypt error", (Throwable)e);
            return new byte[0];
        }
    }

    public byte[] decrypt(byte[] cipher) {
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"cipher", (byte[])cipher);
        int curveLength = 32;
        int hashLength = 32;
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(cipher, 0, c1, 0, c1.length);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"c1", (byte[])c1);
        byte[] x = new byte[curveLength];
        System.arraycopy(c1, 1, x, 0, x.length);
        byte[] y = new byte[curveLength];
        System.arraycopy(c1, x.length + 1, y, 0, y.length);
        byte[] c = new byte[cipher.length - hashLength - c1.length];
        System.arraycopy(cipher, c1.length, c, 0, c.length);
        byte[] m = new byte[hashLength];
        System.arraycopy(cipher, cipher.length - hashLength, m, 0, hashLength);
        SdfECCCipher eccCipher = new SdfECCCipher(x, y, m, c.length, c);
        try {
            if (null == this.stdName) {
                return this.sdfSDK.internalDecryptECC(this.ecKey.getEcIndex(), this.ecKey.getPassword(), c.length, eccCipher);
            }
            return this.sdfSDK.internalDecryptECC(this.ecKey.getEcIndex(), this.ecKey.getPassword(), c.length, eccCipher, this.stdName);
        }
        catch (SdfSDKException e) {
            this.logger.error("decrypt error index={} password={}", new Object[]{this.ecKey.getEcIndex(), this.ecKey.getPassword(), e});
            return new byte[0];
        }
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

