/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.security.PublicKey;

public class SdfECKey {
    private SdfSDK sdfSDK;
    private String stdName;

    public SdfECKey() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
        this.stdName = GMSSLECUtils.SM2p256;
    }

    public SdfECKey(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.stdName = GMSSLECUtils.SM2p256;
        this.sdfSDK.init();
    }

    public SdfECKey(SdfCryptoType sdfCryptoType, String stdName) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.stdName = stdName;
        this.sdfSDK.init();
    }

    public PublicKey exportSignPublicKey(int index) throws SdfSDKException {
        SdfECCPublicKey sdfECCPublicKey = this.sdfSDK.exportSignPublicKeyEcc(index);
        try {
            return GMSSLECUtils.convertECPublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY(), (String)this.stdName);
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public PublicKey exportEncryptPublicKey(int index) throws SdfSDKException {
        SdfECCPublicKey sdfECCPublicKey = this.sdfSDK.exportEncPublicKeyEcc(index);
        try {
            return GMSSLECUtils.convertECPublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY(), (String)this.stdName);
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public void release() throws SdfSDKException {
        this.sdfSDK.release();
    }
}

