/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;

public class SdfECSigner
extends SdfECBaseSigner {
    public SdfECSigner() throws SdfSDKException {
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK());
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
    }

    @Override
    public void initDigest(byte[] userID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        this.digest = new SdfSM3Digest(this.sdfSDK, userID, sdfECCPublicKey);
    }

    @Override
    public void initDigest(String signAlgName) throws SdfSDKException {
        if (signAlgName.toUpperCase().contains("SHA256")) {
            this.digest = new SdfSHADigest(this.sdfSDK, SdfAlgIdHash.SGD_SHA256);
        } else if (signAlgName.toUpperCase().contains("SHA1")) {
            this.digest = new SdfSHADigest(this.sdfSDK, SdfAlgIdHash.SGD_SHA1);
        } else {
            throw new SdfSDKException("unSupport signAlg " + signAlgName);
        }
    }
}

