/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.Enumeration;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfPrivateKey
implements PrivateKey {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int index;
    private byte[] password;

    public static SdfPrivateKey getInstance(Object o) {
        if (o instanceof SdfPrivateKey) {
            return (SdfPrivateKey)o;
        }
        if (o instanceof SecretKeySpec) {
            return new SdfPrivateKey(ASN1Sequence.getInstance((Object)((SecretKeySpec)o).getEncoded()));
        }
        if (o != null) {
            return new SdfPrivateKey(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SdfPrivateKey(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        this.index = ASN1Integer.getInstance(e.nextElement()).getValue().intValue();
        this.password = DEROctetString.getInstance(e.nextElement()).getOctets();
        this.logger.debug("SdfPrivateKey index " + this.index + " password " + new String(this.password));
    }

    public SdfPrivateKey(int index, String password) {
        this.index = index;
        this.password = null == password ? "".getBytes() : password.getBytes();
    }

    public SdfPrivateKey(int index, byte[] password) {
        this.index = index;
        this.password = null == password ? "".getBytes() : password;
    }

    public SdfPrivateKey(int index) {
        this.index = index;
        this.password = "".getBytes();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public String getStringPassword() {
        return new String(this.password);
    }

    @Override
    public String getAlgorithm() {
        return "SDF-PRIVATE";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        ASN1Integer index = new ASN1Integer((long)this.index);
        DEROctetString password = new DEROctetString(this.password);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)index);
        vector.add((ASN1Encodable)password);
        DERSequence sequence = new DERSequence(vector);
        try {
            return sequence.getEncoded();
        }
        catch (IOException e) {
            this.logger.error("sequence getEncoded", (Throwable)e);
            return null;
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    public String toString() {
        return "SdfPrivateKey{ index=" + this.index + ", password=" + new String(this.password) + " }";
    }
}

