package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.CipherParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName SdfRSAEngine
 * @Description TODO
 * @Date 2019/9/12 15:03
 * @Author FengZhen
 */
public class SdfRSAEngine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SdfECKeyParameters ecKey;
    private boolean forEncryption;
    private SdfSDK sdfSDK;

    public SdfRSAEngine() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfRSAEngine(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfRSAEngine(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        this.ecKey = (SdfECKeyParameters) param;
    }

}
