/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfEcSignerWithSoftDigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSASigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHAType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.OutputStream;
import java.security.SignatureException;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfContentOutputStream
extends OutputStream {
    private SdfSigner signer;
    private Exception exception;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private byte[] data = new byte[0];

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, boolean forSigning, AsymmetricKeyParameter asymmetricKeyParameter) {
        this(sdfCryptoType, algorithmIdentifier, forSigning, asymmetricKeyParameter, false);
    }

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, boolean forSigning, AsymmetricKeyParameter asymmetricKeyParameter, boolean useBC) {
        this(sdfCryptoType, algorithmIdentifier, forSigning, asymmetricKeyParameter, useBC, 256);
    }

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, boolean forSigning, AsymmetricKeyParameter asymmetricKeyParameter, boolean useBC, int bits) {
        try {
            if (SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm())) {
                this.signer = new SdfRSASigner(sdfCryptoType, algorithmIdentifier);
            } else if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equals(algorithmIdentifier.getAlgorithm().getId())) {
                this.signer = useBC ? new SdfEcSignerWithSoftDigest(sdfCryptoType) : new SdfECSigner(sdfCryptoType);
            } else {
                String algorithmName = new DefaultAlgorithmNameFinder().getAlgorithmName(algorithmIdentifier);
                this.signer = useBC ? new SdfEcSignerWithSoftDigest(sdfCryptoType, algorithmName, bits) : new SdfECSigner(sdfCryptoType, algorithmName, bits);
            }
            this.signer.init(forSigning, (CipherParameters)asymmetricKeyParameter);
        }
        catch (SdfSDKException e) {
            throw new RuntimeOperatorException("exception obtaining signature init : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(bytes, off, tmp, 0, len);
        this.data = GMSSLByteArrayUtils.mergeByteArray((byte[])this.data, (byte[])tmp);
    }

    @Override
    public void write(byte[] bytes) {
        this.data = GMSSLByteArrayUtils.mergeByteArray((byte[])this.data, (byte[])bytes);
    }

    @Override
    public void write(int var1) {
        byte[] tmp = new byte[]{(byte)var1};
        this.data = GMSSLByteArrayUtils.mergeByteArray((byte[])this.data, (byte[])tmp);
    }

    byte[] getSignature() throws SignatureException {
        try {
            this.signer.update(this.data, 0, this.data.length);
            this.data = new byte[0];
            byte[] signature = this.signer.generateSignature();
            this.signer.release();
            return signature;
        }
        catch (SdfSDKException | CryptoException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }

    boolean verify(byte[] expected) throws SignatureException {
        try {
            this.signer.update(this.data, 0, this.data.length);
            this.data = new byte[0];
            boolean verify = this.signer.verifySignature(expected);
            this.signer.release();
            return verify;
        }
        catch (SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}

