/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentOutputStream;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHAType;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.OutputStream;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.RuntimeOperatorException;

public class SdfContentSigner
implements ContentSigner {
    private SdfContentOutputStream stream;
    private AlgorithmIdentifier algorithmIdentifier;

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, privateKey, false);
    }

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey, int bits) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, privateKey, false, bits);
    }

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey, boolean useBC) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, privateKey, useBC, 256);
    }

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey, boolean useBC, int bits) throws SdfSDKException {
        this.algorithmIdentifier = algorithmIdentifier;
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        asymmetricKeyParameter = SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm()) ? new SdfRSAKeyParameters(privateKey) : new SdfECKeyParameters(privateKey);
        this.stream = new SdfContentOutputStream(sdfCryptoType, algorithmIdentifier, true, asymmetricKeyParameter, useBC, bits);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public byte[] getSignature() {
        try {
            return this.stream.getSignature();
        }
        catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), (Throwable)e);
        }
    }
}

