/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentOutputStream;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHAType;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;

public class SdfContentVerifier
implements ContentVerifier {
    private SdfContentOutputStream stream;

    public SdfContentVerifier(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, publicKey, false);
    }

    public SdfContentVerifier(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey, boolean useBC) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, publicKey, useBC, 256);
    }

    public SdfContentVerifier(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey, boolean useBC, int bits) throws SdfSDKException {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        asymmetricKeyParameter = SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm()) ? new SdfRSAKeyParameters((RSAPublicKey)publicKey) : new SdfECKeyParameters((ECPublicKey)publicKey);
        this.stream = new SdfContentOutputStream(sdfCryptoType, algorithmIdentifier, false, asymmetricKeyParameter, useBC, bits);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public boolean verify(byte[] expected) {
        try {
            return this.stream.verify(expected);
        }
        catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining verify: " + e.getMessage(), (Throwable)e);
        }
    }
}

