/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.dongjin.DongJinSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;

public enum SdfCryptoType {
    PCIE,
    DONGJIN,
    YUNHSM;


    public SdfSDK getSdfSDK() throws SdfSDKException {
        switch (this) {
            case PCIE: {
                return new PcieSdfSDK();
            }
            case YUNHSM: {
                return new YunhsmSdfSDK();
            }
            case DONGJIN: {
                return new DongJinSdfSDK();
            }
        }
        throw new SdfSDKException("un known type");
    }

    public static SdfSDK cloneSdfSDK(SdfSDK sdfSDK) throws SdfSDKException {
        if (sdfSDK instanceof YunhsmSdfSDK) {
            return new YunhsmSdfSDK();
        }
        if (sdfSDK instanceof PcieSdfSDK) {
            return new PcieSdfSDK();
        }
        throw new SdfSDKException("un known type");
    }
}

