/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdAsymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdfECBaseSigner
extends SdfSigner {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExtendedDigest digest;
    protected SdfECKeyParameters ecKey;
    protected String signAlgName = "SM3WITHSM2";
    protected int bits = 256;

    public SdfECBaseSigner() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfECBaseSigner(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfECBaseSigner(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public SdfECBaseSigner(SdfSDK sdfSDK, String signAlgName) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.signAlgName = signAlgName;
        this.sdfSDK.init();
    }

    public void init(boolean forSigning, CipherParameters param) {
        try {
            byte[] userID;
            if (param instanceof ParametersWithID) {
                this.ecKey = (SdfECKeyParameters)((ParametersWithID)param).getParameters();
                userID = ((ParametersWithID)param).getID();
            } else {
                this.ecKey = (SdfECKeyParameters)param;
                userID = Hex.decode((String)"31323334353637383132333435363738");
            }
            switch (this.signAlgName.toUpperCase()) {
                case "SM3WITHSM2": {
                    SdfECCPublicKey sdfECCPublicKey = forSigning ? this.sdfSDK.exportSignPublicKeyEcc(this.ecKey.getEcIndex()) : this.ecKey.getSDFECCPublicKey();
                    this.initDigest(userID, sdfECCPublicKey);
                    break;
                }
                case "SHA1WITHECDSA": 
                case "SHA256WITHECDSA": 
                case "SHA384WITHECDSA": 
                case "SHA512WITHECDSA": {
                    this.initDigest(this.signAlgName);
                    break;
                }
                default: {
                    this.logger.error("init error  un support sign alg name {}", (Object)this.signAlgName);
                    break;
                }
            }
        }
        catch (SdfSDKException e) {
            this.logger.error("init", (Throwable)e);
        }
    }

    public abstract void initDigest(byte[] var1, SdfECCPublicKey var2) throws SdfSDKException;

    public abstract void initDigest(String var1) throws SdfSDKException;

    public void update(byte b) {
        byte[] bytes = new byte[]{b};
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] out = new byte[this.digest.getDigestSize()];
        try {
            SdfECCSignature sdfECCSignature;
            this.digest.doFinal(out, 0);
            switch (this.bits) {
                case 256: {
                    out = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])out, (int)32);
                    sdfECCSignature = this.sdfSDK.internalSignECC(this.ecKey.getEcIndex(), this.ecKey.getPassword(), out);
                    break;
                }
                case 384: 
                case 521: {
                    sdfECCSignature = this.sdfSDK.internalSignECCEx(this.ecKey.getEcIndex(), this.ecKey.getPassword(), out, this.bits);
                    break;
                }
                default: {
                    return null;
                }
            }
            return this.derEncode(sdfECCSignature.getR(), sdfECCSignature.getS());
        }
        catch (SdfSDKException | IOException e) {
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"signature  digest", (byte[])out);
            this.logger.error("generateSignature error index={} password={}", new Object[]{this.ecKey.getEcIndex(), new String(this.ecKey.getPassword()), e});
            throw new CryptoException("sdf ec sign error", e);
        }
    }

    public boolean verifySignature(byte[] signature) {
        byte[] out = new byte[this.digest.getDigestSize()];
        try {
            this.digest.doFinal(out, 0);
            BigInteger[] bigIntegers = GMSSLX509Utils.derSignatureDecode((byte[])signature);
            byte[] r = bigIntegers[0].toByteArray();
            byte[] s = bigIntegers[1].toByteArray();
            SdfECCSignature sdfECCSignature = new SdfECCSignature(r, s);
            switch (this.bits) {
                case 256: {
                    out = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])out, (int)32);
                    if (null == this.signAlgName) {
                        this.sdfSDK.externalVerifyECC(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature);
                        break;
                    }
                    this.sdfSDK.externalVerifyECC(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature, this.signAlgName);
                    break;
                }
                case 384: {
                    this.sdfSDK.externalVerifyECCEx(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature, SdfAlgIdAsymmetric.SGD_ECC_NISTP384, this.bits);
                    break;
                }
                case 521: {
                    this.sdfSDK.externalVerifyECCEx(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature, SdfAlgIdAsymmetric.SGD_ECC_NISTP521, this.bits);
                    break;
                }
                default: {
                    this.logger.error("un support key bits  {}", (Object)this.bits);
                    return false;
                }
            }
            return true;
        }
        catch (SdfSDKException | IOException e) {
            if (signature != null) {
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature digest", (byte[])out, (boolean)true);
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature x", (byte[])this.ecKey.getSDFECCPublicKey().getX(), (boolean)true);
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature y", (byte[])this.ecKey.getSDFECCPublicKey().getY(), (boolean)true);
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature signature", (byte[])signature, (boolean)true);
            }
            this.logger.error("verifySignature", e);
            return false;
        }
    }

    public void reset() {
    }

    protected BigInteger[] derDecode(byte[] encoding) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = this.derEncode(r, s = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])expectedEncoding, (byte[])encoding)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }

    protected byte[] derEncode(byte[] r, byte[] s) throws IOException {
        return this.derEncode(BigIntegers.fromUnsignedByteArray((byte[])r), BigIntegers.fromUnsignedByteArray((byte[])s));
    }

    protected byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }
}

