/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.hsm.api.alg.AlgId;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfECKey {
    private SdfSDK sdfSDK;
    private String stdName;
    private Logger logger = LoggerFactory.getLogger(SdfECKey.class);
    private SdfCryptoType sdfCryptoType;
    private static final int LENGTH_32 = 32;
    private static final int LENGTH_48 = 48;
    private static final int LENGTH_66 = 66;

    public SdfECKey() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
        this.stdName = GMSSLECUtils.SM2p256;
        this.sdfCryptoType = SdfCryptoType.YUNHSM;
    }

    public SdfECKey(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.stdName = GMSSLECUtils.SM2p256;
        this.sdfSDK.init();
        this.sdfCryptoType = sdfCryptoType;
    }

    public SdfECKey(SdfCryptoType sdfCryptoType, String stdName) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.stdName = stdName;
        this.sdfSDK.init();
        this.sdfCryptoType = sdfCryptoType;
    }

    public PublicKey exportSignPublicKey(int index) throws SdfSDKException {
        return this.exportPublicKey(index, false);
    }

    public PublicKey exportEncryptPublicKey(int index) throws SdfSDKException {
        return this.exportPublicKey(index, true);
    }

    public PublicKey exportPublicKey(int index, boolean isEncrypt) throws SdfSDKException {
        try {
            switch (this.stdName) {
                case "P-256": 
                case "sm2p256v1": {
                    SdfECCPublicKey sdfECCPublicKey = isEncrypt ? this.sdfSDK.exportEncPublicKeyEcc(index) : this.sdfSDK.exportSignPublicKeyEcc(index);
                    return GMSSLECUtils.convertECPublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY(), (String)this.stdName);
                }
                case "P-384": 
                case "P-521": {
                    SdfECCPublicKey sdfECCPublicKey = isEncrypt ? this.sdfSDK.exportEncPublicKeyEccEx(index) : this.sdfSDK.exportSignPublicKeyEccEx(index);
                    return GMSSLECUtils.convertPublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY(), (String)this.stdName);
                }
            }
            this.logger.error("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf\uff0c\u540d\u79f0\u4e3a{}", (Object)this.stdName);
            throw new SdfSDKException("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u516c\u94a5\u5931\u8d25", (Throwable)e);
            throw new SdfSDKException((Throwable)e);
        }
    }

    public KeyPair generateKeyPair() throws SdfSDKException {
        try {
            SdfECCKeyPair sdfECCKeyPair;
            switch (this.stdName) {
                case "P-256": {
                    sdfECCKeyPair = this.sdfSDK.generateKeyPairEcc(AlgId.SGD_ECC_NISTP256);
                    break;
                }
                case "sm2p256v1": {
                    sdfECCKeyPair = this.sdfSDK.generateKeyPairEcc(AlgId.SGD_SM2);
                    break;
                }
                case "P-384": {
                    sdfECCKeyPair = this.sdfSDK.generateKeyPairEccEx(AlgId.SGD_ECC_NISTP384, 384);
                    break;
                }
                case "P-521": {
                    sdfECCKeyPair = this.sdfSDK.generateKeyPairEccEx(AlgId.SGD_ECC_NISTP521, 521);
                    break;
                }
                default: {
                    this.logger.error("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf\uff0c\u540d\u79f0\u4e3a{}", (Object)this.stdName);
                    throw new SdfSDKException("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf");
                }
            }
            PrivateKey privateKey = this.generateEcPrivateKey(sdfECCKeyPair.getSdfECCPrivateKey());
            PublicKey publicKey = this.generateEcPublicKey(sdfECCKeyPair.getSdfECCPublicKey());
            this.sdfSDK.release();
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\uff0c\u66f2\u7ebf\u540d\u79f0\u4e3a{}", (Object)this.stdName, (Object)e);
            throw new SdfSDKException((Throwable)e);
        }
    }

    private PrivateKey generateEcPrivateKey(SdfECCPrivateKey sdfECCPrivateKey) throws SdfSDKException {
        try {
            switch (this.stdName) {
                case "P-256": 
                case "sm2p256v1": {
                    if (this.sdfCryptoType == SdfCryptoType.YUNHSM) {
                        return GMSSLECUtils.convertECPrivateKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])sdfECCPrivateKey.getK(), (int)32), (String)this.stdName);
                    }
                    return GMSSLECUtils.convertECPrivateKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])sdfECCPrivateKey.getK(), (int)32), (String)this.stdName);
                }
                case "P-521": {
                    if (this.sdfCryptoType == SdfCryptoType.YUNHSM) {
                        return GMSSLECUtils.convertECPrivateKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])sdfECCPrivateKey.getK(), (int)66), (String)this.stdName);
                    }
                    return GMSSLECUtils.convertECPrivateKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])sdfECCPrivateKey.getK(), (int)66), (String)this.stdName);
                }
                case "P-384": {
                    if (this.sdfCryptoType == SdfCryptoType.YUNHSM) {
                        return GMSSLECUtils.convertECPrivateKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])sdfECCPrivateKey.getK(), (int)48), (String)this.stdName);
                    }
                    return GMSSLECUtils.convertECPrivateKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])sdfECCPrivateKey.getK(), (int)48), (String)this.stdName);
                }
            }
            this.logger.error("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf\uff0c\u540d\u79f0\u4e3a{}", (Object)this.stdName);
            throw new SdfSDKException("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf");
        }
        catch (Exception e) {
            this.logger.error("\u8f6c\u6362\u79c1\u94a5\u5931\u8d25\uff0c\u66f2\u7ebf\u540d\u79f0\u4e3a{}", (Object)this.stdName, (Object)e);
            throw new SdfSDKException("\u8f6c\u6362\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    private PublicKey generateEcPublicKey(SdfECCPublicKey publicKey) throws SdfSDKException {
        try {
            switch (this.stdName) {
                case "sm2p256v1": 
                case "P-256": {
                    if (this.sdfCryptoType == SdfCryptoType.YUNHSM) {
                        return GMSSLECUtils.convertPublicKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getX(), (int)32), (byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getY(), (int)32), (String)this.stdName);
                    }
                    return GMSSLECUtils.convertPublicKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])publicKey.getX(), (int)32), (byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getY(), (int)32), (String)this.stdName);
                }
                case "P-384": {
                    if (this.sdfCryptoType == SdfCryptoType.YUNHSM) {
                        return GMSSLECUtils.convertPublicKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getX(), (int)48), (byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getY(), (int)48), (String)this.stdName);
                    }
                    return GMSSLECUtils.convertPublicKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])publicKey.getX(), (int)48), (byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getY(), (int)48), (String)this.stdName);
                }
                case "P-521": {
                    if (this.sdfCryptoType == SdfCryptoType.YUNHSM) {
                        return GMSSLECUtils.convertPublicKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getX(), (int)66), (byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getY(), (int)66), (String)this.stdName);
                    }
                    return GMSSLECUtils.convertPublicKey((byte[])GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])publicKey.getX(), (int)66), (byte[])GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])publicKey.getY(), (int)66), (String)this.stdName);
                }
            }
            this.logger.error("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf\uff0c\u540d\u79f0\u4e3a{}", (Object)this.stdName);
            throw new SdfSDKException("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf");
        }
        catch (Exception e) {
            this.logger.error("\u8f6c\u6362\u516c\u94a5\u94a5\u5931\u8d25\uff0c\u66f2\u7ebf\u540d\u79f0\u4e3a{}", (Object)this.stdName, (Object)e);
            throw new SdfSDKException("\u8f6c\u6362\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public void release() throws SdfSDKException {
        this.sdfSDK.release();
    }
}

