/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;

public class SdfECSigner
extends SdfECBaseSigner {
    public SdfECSigner() throws SdfSDKException {
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK());
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType, String signAlgName, int bits) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
        this.bits = bits;
    }

    @Override
    public void initDigest(byte[] userID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        this.digest = new SdfSM3Digest(this.sdfSDK, userID, sdfECCPublicKey);
    }

    @Override
    public void initDigest(String signAlgName) throws SdfSDKException {
        switch (signAlgName.toUpperCase()) {
            case "SHA1WITHECDSA": {
                this.digest = new SdfSHADigest(this.sdfSDK, SdfAlgIdHash.SGD_SHA1);
                break;
            }
            case "SHA256WITHECDSA": {
                this.digest = new SdfSHADigest(this.sdfSDK, SdfAlgIdHash.SGD_SHA256);
                break;
            }
            case "SHA384WITHECDSA": {
                this.digest = new SdfSHADigest(this.sdfSDK, SdfAlgIdHash.SGD_SHA384);
                break;
            }
            case "SHA512WITHECDSA": {
                this.digest = new SdfSHADigest(this.sdfSDK, SdfAlgIdHash.SGD_SHA512);
                break;
            }
            default: {
                throw new SdfSDKException("unSupport signAlg " + signAlgName);
            }
        }
    }
}

