/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.math.BigInteger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class SdfEcSignerWithSoftDigest
extends SdfECBaseSigner {
    public SdfEcSignerWithSoftDigest() throws SdfSDKException {
        super(SdfCryptoType.YUNHSM);
    }

    public SdfEcSignerWithSoftDigest(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK());
    }

    public SdfEcSignerWithSoftDigest(SdfSDK sdfSDK) throws SdfSDKException {
        super(sdfSDK);
    }

    public SdfEcSignerWithSoftDigest(SdfSDK sdfSDK, String signAlgName) throws SdfSDKException {
        super(sdfSDK, signAlgName);
    }

    public SdfEcSignerWithSoftDigest(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
    }

    public SdfEcSignerWithSoftDigest(SdfCryptoType sdfCryptoType, String signAlgName, int bits) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
        this.bits = bits;
    }

    @Override
    public void initDigest(byte[] userID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        this.digest = new SM3Digest();
        byte[] z = this.getZ(userID, sdfECCPublicKey.getX(), sdfECCPublicKey.getY());
        this.digest.update(z, 0, z.length);
    }

    @Override
    public void initDigest(String signAlgName) throws SdfSDKException {
        switch (signAlgName.toUpperCase()) {
            case "SHA1WITHECDSA": {
                this.digest = new SHA1Digest();
                break;
            }
            case "SHA256WITHECDSA": {
                this.digest = new SHA256Digest();
                break;
            }
            case "SHA384WITHECDSA": {
                this.digest = new SHA384Digest();
                break;
            }
            case "SHA512WITHECDSA": {
                this.digest = new SHA512Digest();
                break;
            }
            default: {
                throw new SdfSDKException("unSupport signAlg " + signAlgName);
            }
        }
    }

    private byte[] getZ(byte[] userID, byte[] x, byte[] y) {
        this.digest.reset();
        this.addUserID((Digest)this.digest, userID);
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)GMSSLX509Utils.ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint G = ecParameterSpec.getG();
        this.addFieldElement((Digest)this.digest, curve.getA().toBigInteger());
        this.addFieldElement((Digest)this.digest, curve.getB().toBigInteger());
        this.addFieldElement((Digest)this.digest, G.getAffineXCoord().toBigInteger());
        this.addFieldElement((Digest)this.digest, G.getAffineYCoord().toBigInteger());
        this.addFieldElement((Digest)this.digest, BigIntegers.fromUnsignedByteArray((byte[])x));
        this.addFieldElement((Digest)this.digest, BigIntegers.fromUnsignedByteArray((byte[])y));
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        return result;
    }

    private void addUserID(Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(Digest digest, BigInteger p) {
        byte[] in = GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)p);
        digest.update(in, 0, in.length);
    }
}

