/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfRSASigner
extends SdfSigner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExtendedDigest sdfSHADigest;
    private SdfRSAKeyParameters keyParameters;
    private AlgorithmIdentifier algId;
    private SdfAlgIdHash sdfAlgIdHash;

    public SdfRSASigner(SdfCryptoType sdfCryptoType, ASN1ObjectIdentifier aid) throws SdfSDKException {
        this(sdfCryptoType, SdfAlgIdHash.converSdfAlgIdHash((ASN1ObjectIdentifier)aid));
    }

    public SdfRSASigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithm) throws SdfSDKException {
        this(sdfCryptoType, algorithm.getAlgorithm());
    }

    public SdfRSASigner(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfAlgIdHash);
    }

    public SdfRSASigner(SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfCryptoType, sdfAlgIdHash);
    }

    public SdfRSASigner(SdfSDK sdfSDK, SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.algId = SdfAlgIdHash.convertAlgorithmIdentifier((SdfAlgIdHash)sdfAlgIdHash);
        this.sdfAlgIdHash = sdfAlgIdHash;
        if (sdfAlgIdHash == SdfAlgIdHash.SGD_SHA1) {
            this.sdfSHADigest = sdfCryptoType == SdfCryptoType.YUNHSM ? new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA1) : new SHA1Digest();
        } else if (sdfAlgIdHash == SdfAlgIdHash.SGD_SHA256) {
            this.sdfSHADigest = sdfCryptoType == SdfCryptoType.YUNHSM ? new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA256) : new SHA256Digest();
        } else {
            throw new SdfSDKException("unsupported " + sdfAlgIdHash.getName() + " hash type");
        }
        this.sdfSDK.init();
    }

    public void init(boolean forSigning, CipherParameters param) {
        this.keyParameters = (SdfRSAKeyParameters)param;
    }

    public void update(byte b) {
        byte[] bytes = new byte[]{b};
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] in, int off, int len) {
        this.sdfSHADigest.update(in, off, len);
    }

    public byte[] generateSignature() throws DataLengthException {
        try {
            byte[] out = new byte[this.sdfSHADigest.getDigestSize()];
            this.sdfSHADigest.doFinal(out, 0);
            SdfRSAPublicKey sdfRSAPublicKey = this.sdfSDK.exportSignPublicKeyRsa(this.keyParameters.getPrivateKeyIndex());
            byte[] data = this.derEncode(out, sdfRSAPublicKey.getBits() / 8);
            if (data.length == 0) {
                return data;
            }
            byte[] sign = this.sdfSDK.internalPrivateKeyOperationRsa(this.keyParameters.getPrivateKeyIndex(), this.keyParameters.getPassword(), data);
            return sign;
        }
        catch (Exception e) {
            this.logger.error("generateSignature", (Throwable)e);
            return new byte[0];
        }
    }

    public boolean verifySignature(byte[] signature) {
        try {
            byte[] out = new byte[this.sdfSHADigest.getDigestSize()];
            this.sdfSHADigest.doFinal(out, 0);
            RSAPublicKey rsaPublicKey = this.keyParameters.getPublicKey();
            SdfRSAPublicKey sdfRSAPublicKey = SdfRSAPublicKey.getInstance((RSAPublicKey)rsaPublicKey);
            byte[] normal = this.derEncode(out, sdfRSAPublicKey.getBits() / 8);
            byte[] verify = this.sdfSDK.externalPublicKeyOperationRsa(sdfRSAPublicKey, signature);
            return GMSSLByteArrayUtils.isEqual((byte[])normal, (byte[])verify);
        }
        catch (Exception e) {
            if (signature != null) {
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature signature", (byte[])signature);
            }
            this.logger.error("verifySignature", (Throwable)e);
            return false;
        }
    }

    public void reset() {
    }

    private byte[] derEncode(byte[] hash, int length) throws IOException {
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        byte[] encoded = dInfo.getEncoded("DER");
        return this.pkcs1Padding(encoded, length);
    }
}

