/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.encoders.Hex;

public abstract class SdfSigner
implements Signer,
ECConstants {
    protected SdfSDK sdfSDK;

    protected byte[] pkcs1Padding(byte[] data, int length) {
        byte[] start = Hex.decode((String)"0001");
        byte[] end = Hex.decode((String)"00");
        int paddingLength = length - data.length - start.length - end.length;
        byte[] paddingData = new byte[paddingLength];
        for (int i = 0; i < paddingLength; ++i) {
            paddingData[i] = -1;
        }
        byte[] a = GMSSLByteArrayUtils.mergeByteArray((byte[])start, (byte[])paddingData);
        byte[] b = GMSSLByteArrayUtils.mergeByteArray((byte[])a, (byte[])end);
        return GMSSLByteArrayUtils.mergeByteArray((byte[])b, (byte[])data);
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

