/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSymmetricCipher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BLOCK_SIZE = 16;
    private static final int HSM_BLOCK_SIZE = 4096;
    private SdfSDK sdfSDK;
    private long[] phKeyHandle;
    private byte[] key;
    private boolean forEncryption;
    private ParametersWithIV parametersWithIV;
    private SdfSymmetricKeyParameters sdfBlockCipherKeyParameters;

    public SdfSymmetricCipher() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfSymmetricCipher(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSymmetricCipher(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        try {
            this.sdfSDK.init();
        }
        catch (SdfSDKException e) {
            throw new IllegalArgumentException("sdf SDK init error", e);
        }
        if (params instanceof SdfSymmetricKeyParameters) {
            this.sdfBlockCipherKeyParameters = (SdfSymmetricKeyParameters)params;
            this.parametersWithIV = new ParametersWithIV(params, new byte[16]);
        } else if (params instanceof ParametersWithIV) {
            this.parametersWithIV = (ParametersWithIV)params;
            this.sdfBlockCipherKeyParameters = (SdfSymmetricKeyParameters)((ParametersWithIV)params).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameter passed to SdfSymmetricCipher init - " + params.getClass().getName());
        }
        this.forEncryption = forEncryption;
        if (this.sdfBlockCipherKeyParameters.getKeyCipherType() == SdfSymmetricKeyParameters.KeyCipherType.NONE) {
            try {
                SdfSymmetricKey sdfSymmetricKey = new SdfSymmetricKey(this.sdfSDK);
                SdfSymmetricKey.KeyHandle keyHandle = sdfSymmetricKey.generateKeyWithEpkEccKeyHandle((ECPublicKey)this.sdfBlockCipherKeyParameters.getPublicKey());
                this.key = keyHandle.getCipherKey();
                this.phKeyHandle = keyHandle.getHandle();
            }
            catch (SdfSDKException e) {
                throw new IllegalArgumentException("SDF SM4 init - generate key error");
            }
            return;
        }
        this.key = this.sdfBlockCipherKeyParameters.getKey();
        try {
            switch (this.sdfBlockCipherKeyParameters.getKeyCipherType()) {
                case ECC_CIPHER: {
                    SdfSymmetricKey eccSymmetricKey = new SdfSymmetricKey(this.sdfSDK);
                    this.phKeyHandle = eccSymmetricKey.importKeyWithIskEcc(this.sdfBlockCipherKeyParameters.getSdfPrivateKey(), this.key);
                    break;
                }
                case PLAIN: {
                    if (this.key.length != 16) {
                        throw new IllegalArgumentException("SM4 requires a 128 bit key");
                    }
                    this.phKeyHandle = this.sdfSDK.importKey(this.key);
                    break;
                }
                case RSA_CIPHER: {
                    SdfSymmetricKey rsaSymmetricKey = new SdfSymmetricKey(this.sdfSDK);
                    this.phKeyHandle = rsaSymmetricKey.importKeyWithIskRsa(this.sdfBlockCipherKeyParameters.getSdfPrivateKey(), this.key);
                    break;
                }
                case KEK: {
                    SdfSymmetricKey kekSymmetricKey = new SdfSymmetricKey(this.sdfSDK);
                    this.phKeyHandle = kekSymmetricKey.importKeyWithKek(this.sdfBlockCipherKeyParameters.getKeyEncryptKeyType(), this.sdfBlockCipherKeyParameters.getPrivateKeyIndex(), this.key);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("SDF SM4 init - unknown key cipher type " + (Object)((Object)this.sdfBlockCipherKeyParameters.getKeyCipherType()));
                }
            }
        }
        catch (SdfSDKException e) {
            this.logger.error("init import key", (Throwable)e);
            throw new IllegalArgumentException("SDF SM4 init - import key error");
        }
    }

    public String getAlgorithmName() {
        return this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher().getName();
    }

    public int getBlockSize() {
        return 16;
    }

    public int getEncryptionLength(int inLength, SdfSymmetricKeyParameters.PaddingType paddingType) {
        if (paddingType == SdfSymmetricKeyParameters.PaddingType.NoPadding) {
            return inLength;
        }
        int paddingLength = 16 - inLength % 16;
        return inLength + paddingLength;
    }

    public byte[] doFinal(byte[] data) throws DataLengthException, IllegalStateException {
        try {
            byte[] plainText;
            byte[] iv = this.parametersWithIV.getIV();
            if (this.forEncryption) {
                byte[] plainText2;
                if (this.sdfBlockCipherKeyParameters.getPaddingType() == SdfSymmetricKeyParameters.PaddingType.NoPadding) {
                    plainText2 = new byte[data.length];
                    System.arraycopy(data, 0, plainText2, 0, data.length);
                } else {
                    int paddingLength = 16 - data.length % 16;
                    plainText2 = new byte[data.length + paddingLength];
                    System.arraycopy(data, 0, plainText2, 0, data.length);
                    byte padding = this.sdfBlockCipherKeyParameters.getPaddingType() == SdfSymmetricKeyParameters.PaddingType.SSL3Padding ? (byte)(paddingLength - 1) : (byte)paddingLength;
                    int off = data.length;
                    for (int i = 0; i < paddingLength; ++i) {
                        plainText2[off++] = padding;
                    }
                }
                int start = 0;
                byte[] pucEncData = new byte[plainText2.length];
                while (plainText2.length > 4096) {
                    byte[] snapPlainText = new byte[4096];
                    System.arraycopy(plainText2, 0, snapPlainText, 0, 4096);
                    byte[] snapPucEncData = this.sdfSDK.encrypt(this.phKeyHandle, this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher(), iv, snapPlainText);
                    if (null != iv) {
                        System.arraycopy(snapPucEncData, 4080, iv, 0, 16);
                    }
                    System.arraycopy(snapPucEncData, 0, pucEncData, start, snapPlainText.length);
                    byte[] getPlainText = new byte[plainText2.length - 4096];
                    System.arraycopy(plainText2, 4096, getPlainText, 0, getPlainText.length);
                    plainText2 = getPlainText;
                    start += 4096;
                }
                byte[] lastTimePucEncData = this.sdfSDK.encrypt(this.phKeyHandle, this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher(), iv, plainText2);
                System.arraycopy(lastTimePucEncData, 0, pucEncData, start, plainText2.length);
                return pucEncData;
            }
            int start = 0;
            byte[] plain = new byte[data.length];
            while (data.length > 4096) {
                byte[] snapEncText = new byte[4096];
                System.arraycopy(data, 0, snapEncText, 0, 4096);
                byte[] snapPlainData = this.sdfSDK.decrypt(this.phKeyHandle, this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher(), iv, snapEncText);
                if (null != iv) {
                    System.arraycopy(snapEncText, 4080, iv, 0, 16);
                }
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"iv", (byte[])iv);
                System.arraycopy(snapPlainData, 0, plain, start, snapPlainData.length);
                byte[] getEncText = new byte[data.length - 4096];
                System.arraycopy(data, 4096, getEncText, 0, getEncText.length);
                data = getEncText;
                start += 4096;
            }
            byte[] lastTimePlainData = this.sdfSDK.decrypt(this.phKeyHandle, this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher(), iv, data);
            System.arraycopy(lastTimePlainData, 0, plain, start, data.length);
            byte lastByte = plain[plain.length - 1];
            switch (this.sdfBlockCipherKeyParameters.getPaddingType()) {
                case PKCS5Padding: 
                case PKCS7Padding: {
                    int pl7 = lastByte & 0xFF;
                    if (pl7 < 1 || pl7 > 16) {
                        this.release();
                        throw new DataLengthException("decrypt error, padding is " + pl7);
                    }
                    plainText = new byte[plain.length - pl7];
                    break;
                }
                case SSL3Padding: {
                    int plssl3 = lastByte & 0xFF;
                    if (plssl3 < 0 || plssl3 > 15) {
                        this.release();
                        throw new DataLengthException("decrypt error, padding is " + plssl3);
                    }
                    plainText = new byte[plain.length - (plssl3 + 1)];
                    break;
                }
                default: {
                    plainText = new byte[plain.length];
                }
            }
            System.arraycopy(plain, 0, plainText, 0, plainText.length);
            return plainText;
        }
        catch (SdfSDKException e) {
            this.logger.error("processBlock", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void reset() {
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null && this.phKeyHandle != null) {
            this.sdfSDK.destroyKey(this.phKeyHandle);
            this.sdfSDK.release();
        }
    }
}

