/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.sdf.jni.bean.EccPrivateKey;
import com.xdja.pcie.sdf.jni.bean.EccPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;

public class PcieSdfSDKUtils {
    public static EccPublicKey generateEccPublicKey(Logger logger, PublicKey key) {
        ECPublicKey ecPublicKey = (ECPublicKey)key;
        return PcieSdfSDKUtils.generateEccPublicKey(logger, GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPublicKey.getW().getAffineX()), GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPublicKey.getW().getAffineY()));
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        logger.info(key.toString());
        return PcieSdfSDKUtils.generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        logger.info("generateEccPublicKey");
        EccPublicKey pucPublicKey = new EccPublicKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])x), GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])y));
        return pucPublicKey;
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
        return PcieSdfSDKUtils.generateEccPrivateKey(logger, GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPrivateKey.getS()));
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        logger.info("generateEccPrivateKey");
        EccPrivateKey pucPrivateKey = new EccPrivateKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])k));
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"pucPrivateKey k", (byte[])pucPrivateKey.getK());
        return pucPrivateKey;
    }

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(inputStream);
        return certificate.getPublicKey();
    }
}

