package com.xdja.pcie.sdf.jni.bean;

import java.io.Serializable;
import java.util.Arrays;

/**
 * ECC私钥数据实体定义
 * @author wyf
 *
 */
public class EccPrivateKey implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 密钥位长
	 */
	private int bits;
	/**
	 * 私钥
	 */
	private byte[] k = new byte[EccPublicKey.ECC_MAX_LEN];

	public EccPrivateKey() {
		super();
	}

	public EccPrivateKey(int bits, byte[] k) {
		super();
		this.bits = bits;
		this.k = k;
	}

	/**
	 * 获得 bits
	 * @return bits 参见 {@linkplain #bits} 
	 */
	public int getBits() {
		return bits;
	}

	/**
	 * 设置 bits
	 * @param bits 参见 {@linkplain #bits}
	 */
	public void setBits(int bits) {
		this.bits = bits;
	}

	/**
	 * 获得 k
	 * @return k 参见 {@linkplain #k} 
	 */
	public byte[] getK() {
		return k;
	}

	/**
	 * 设置 k
	 * @param k 参见 {@linkplain #k}
	 */
	public void setK(byte[] k) {
		this.k = k;
	}

	@Override
	public String toString() {
		return "EccPrivateKey [bits=" + bits + ", k=" + Arrays.toString(k) + "]";
	}
	
}
