package com.xdja.pcie.sdf.jni.bean;

import java.io.Serializable;

/**
 * 密码设备应用接口返回代码定义
 * @author wyf
 *
 */
public class SdfApiCode implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 操作成功
	 */
	public final static int SDR_OK = 0x0;
	/**
	 * 错误码基础值
	 */
	public final static int SDR_BASE = 0x01000000;
	/**
	 * 未知错误
	 */
	public final static int SDR_UNKNOWERR = 0x01000001;
	/**
	 * 不支持的接口调用
	 */
	public final static int SDR_NOTSUPPORT = 0x01000002;
	/**
	 * 与设备通信失败
	 */
	public final static int SDR_COMMFAIL = 0x01000003;
	/**
	 * 运算模块无响应
	 */
	public final static int SDR_HARDFAIL = 0x01000004;
	/**
	 * 打开设备失败
	 */
	public final static int SDR_OPENDEVICE = 0x01000005;
	/**
	 * 创建会话失败
	 */
	public final static int SDR_OPENSESSION = 0x01000006;
	/**
	 * 无私钥使用权限
	 */
	public final static int SDR_PARDENY = 0x01000007;
	/**
	 * 不存在的密钥调用
	 */
	public final static int SDR_KEYNOTEXIST = 0x01000008;
	/**
	 * 不支持的算法调用
	 */
	public final static int SDR_ALGNOTSUPPORT = 0x01000009;
	/**
	 * 不支持的算法模式调用
	 */
	public final static int SDR_ALGMODNOTSUPPORT = 0x0100000A;
	/**
	 * 公钥运算失败
	 */
	public final static int SDR_PKOPERR = 0x0100000B;
	/**
	 * 私钥运算失败
	 */
	public final static int SDR_SKOPERR = 0x0100000C;
	/**
	 * 签名运算失败
	 */
	public final static int SDR_SIGNERR = 0x0100000D;
	/**
	 * 验证签名失败
	 */
	public final static int SDR_VERIFYERR = 0x0100000E;
	/**
	 * 对称算法运算失败
	 */
	public final static int SDR_SYMOPERR = 0x0100000F;
	/**
	 * 多步运算步骤错误
	 */
	public final static int SDR_STEPERR = 0x01000010;
	/**
	 * 文件长度超出限制
	 */
	public final static int SDR_FILESIZEERR = 0x01000011;
	/**
	 * 指定的文件不存在
	 */
	public final static int SDR_FILENOEXIST = 0x01000012;
	/**
	 * 文件起始位置错误
	 */
	public final static int SDR_FILEOFSERR = 0x01000013;
	/**
	 * 密钥类型错误
	 */
	public final static int SDR_KEYTYPEERR = 0x01000014;
	/**
	 * 密钥错误
	 */
	public final static int SDR_KEYERR = 0x01000015;
	/**
	 * ECC加密数据错误
	 */
	public final static int SDR_ENCDATAERR = 0x01000016;
	/**
	 * 随机数产生失败
	 */
	public final static int SDR_RANDERR = 0x01000017;
	/**
	 * 私钥使用权限获取失败
	 */
	public final static int SDR_PRKRERR = 0x01000018;
	/**
	 * MAC运算失败
	 */
	public final static int SDR_MACERR = 0x01000019;
	/**
	 * 指定文件已存在
	 */
	public final static int SDR_FILEEXISTS = 0x0100001A;
	/**
	 * 文件写入失败
	 */
	public final static int SDR_FILEWERR = 0x0100001B;
	/**
	 * 存储空间不足
	 */
	public final static int SDR_NOBUFFER = 0x0100001C;
	/**
	 * 输入参数错误
	 */
	public final static int SDR_INARGERR = 0x0100001D;
	/**
	 * 输出参数错误
	 */
	public final static int SDR_OUTARGERR = 0x0100001E;

}
