/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.sdf.jni.SdfApi;
import com.xdja.pcie.sdf.jni.alg.AlgId;
import com.xdja.pcie.sdf.jni.bean.DeviceInfo;
import com.xdja.pcie.sdf.jni.bean.EccCipher;
import com.xdja.pcie.sdf.jni.bean.EccPrivateKey;
import com.xdja.pcie.sdf.jni.bean.EccPublicKey;
import com.xdja.pcie.sdf.jni.bean.EccSignature;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRsaKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfSymmetricKeyHandle;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;

public class PcieSdfSDK
extends AbstractSdfSDK {
    private SdfApi sdfApi = new SdfApi();

    public void init() throws SdfSDKException {
        int ret = this.sdfApi.openDevice(this.dev);
        this.checkRet("openDevice", ret);
        ret = this.sdfApi.openSession(this.dev[0], this.ses);
        this.checkRet("openSession", ret);
    }

    public void release() throws SdfSDKException {
        int ret = this.sdfApi.closeSession(this.ses[0]);
        this.checkRet("closeSession", ret);
        ret = this.sdfApi.closeDevice(this.dev[0]);
        this.checkRet("closeDevice", ret);
        this.dev = new long[]{0L};
        this.ses = new long[]{0L};
    }

    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        int ret = this.sdfApi.generateRandom(this.ses[0], uiLength, pucRandom);
        this.checkRet("generateRandom", ret);
        return pucRandom;
    }

    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        int ret = this.sdfApi.generateKeyPairEcc(this.ses[0], AlgId.SGD_SM2, 256, pucPublicKey, pucPrivateKey);
        this.checkRet("generateKeyPairEcc", ret);
        byte[] k = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucPrivateKey.getK());
        return new SdfECCKeyPair(SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY()), SdfECCPrivateKey.getInstanceFilterFoot((byte[])pucPrivateKey.getK()));
    }

    public SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        int ret = this.sdfApi.generateKeyPairEcc(this.ses[0], algId, 256, pucPublicKey, pucPrivateKey);
        this.checkRet("generateKeyPairEcc", ret);
        byte[] k = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucPrivateKey.getK());
        return new SdfECCKeyPair(SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY()), SdfECCPrivateKey.getInstanceFilterFoot((byte[])pucPrivateKey.getK()));
    }

    public boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        boolean result = false;
        int ret = this.sdfApi.getPrivateKeyAccessRight(this.ses[0], index, password, password.length);
        if (ret == 0) {
            this.sdfApi.releasePrivateKeyAccessRight(this.ses[0], index);
            result = true;
        }
        this.checkRet("checkPrivateKeyAccessRight", ret);
        return result;
    }

    public void getPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        int ret = this.sdfApi.getPrivateKeyAccessRight(this.ses[0], index, password, password.length);
        this.checkRet("getPrivateKeyAccessRight", ret);
    }

    public void releasePrivateKeyAccessRight(int index) throws SdfSDKException {
        int ret = this.sdfApi.releasePrivateKeyAccessRight(this.ses[0], index);
        this.checkRet("releasePrivateKeyAccessRight", ret);
    }

    public PublicKey importSM2SignKey(KeyStore keyStore, char[] pw, int index) throws SdfSDKException {
        return this.importSM2Key(keyStore, pw, index, true);
    }

    public PublicKey importSM2EnvKey(KeyStore keyStore, char[] pw, int index) throws SdfSDKException {
        return this.importSM2Key(keyStore, pw, index, false);
    }

    private PublicKey importSM2Key(KeyStore keyStore, char[] pw, int index, boolean isSign) throws SdfSDKException {
        try {
            String alias = keyStore.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, pw);
            PublicKey publicKey = keyStore.getCertificate(alias).getPublicKey();
            this.importSM2PrivateKey(privateKey, index, isSign);
            this.importSM2PublicKey(publicKey, index, isSign);
            return publicKey;
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public void importSM2PublicKey(PublicKey key, int index, boolean isSign) throws SdfSDKException {
        String method = isSign ? "sm2ImportSignpub" : "sm2ImportEncpub";
        EccPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, key);
        int ret = isSign ? this.sdfApi.sm2ImportSignpub(this.ses[0], index, pucPublicKey) : this.sdfApi.sm2ImportEncpub(this.ses[0], index, pucPublicKey);
        this.checkRet(method, ret);
        EccPublicKey ecPublicKey_exp = new EccPublicKey();
        ret = isSign ? this.sdfApi.exportSignPublicKeyEcc(this.ses[0], index, ecPublicKey_exp) : this.sdfApi.exportEncPublicKeyEcc(this.ses[0], index, ecPublicKey_exp);
        this.checkRet("exportSignPublicKeyEcc", ret);
    }

    public void importSM2PrivateKey(PrivateKey key, int index, boolean isSign) throws SdfSDKException {
        String method = isSign ? "sm2ImportSignpri" : "sm2ImportEncpri";
        EccPrivateKey pucPrivateKey = PcieSdfSDKUtils.generateEccPrivateKey(this.logger, key);
        int ret = isSign ? this.sdfApi.sm2ImportSignpri(this.ses[0], index, pucPrivateKey, 0) : this.sdfApi.sm2ImportEncpri(this.ses[0], index, pucPrivateKey, 0);
        this.checkRet(method, ret);
    }

    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        EccSignature pucSignature = new EccSignature();
        int ret = this.sdfApi.internalSignEcc(this.ses[0], index, data, data.length, pucSignature);
        if (ret == 0x1000007) {
            this.release();
            this.init();
            this.getPrivateKeyAccessRight(index, password);
            ret = this.sdfApi.internalSignEcc(this.ses[0], index, data, data.length, pucSignature);
            this.checkRet("internalSignECC next", ret);
        } else {
            this.checkRet("internalSignECC", ret);
        }
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        int ret = this.sdfApi.exportSignPublicKeyEcc(this.ses[0], index, pucPublicKey);
        this.checkRet("exportSignPublicKeyEcc", ret);
        return SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCSignature.getS());
        EccSignature pucSignature = new EccSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])publicKey.getY());
        this.logger.info("data length " + data.length);
        EccPublicKey pucPublicKey = new EccPublicKey(256, x, y);
        int ret = this.sdfApi.externalVerifyEcc(this.ses[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucSignature);
        this.checkRet("externalVerifyECC", ret);
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException {
    }

    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        int ret = this.sdfApi.exportEncPublicKeyEcc(this.ses[0], index, pucPublicKey);
        this.checkRet("exportEncPublicKeyEcc", ret);
        return SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey sdfECCPublicKey, byte[] data) throws SdfSDKException {
        EccCipher pucEncData = new EccCipher();
        EccPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        int ret = this.sdfApi.externalEncryptEcc(this.ses[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucEncData);
        this.checkRet("externalEncryptECC", ret);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data, String stdName) throws SdfSDKException {
        return null;
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getY());
        EccCipher pucEncData = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = new int[]{len};
        int ret = this.sdfApi.internalDecryptEcc(this.ses[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        if (ret == 0x1000007) {
            this.release();
            this.init();
            this.getPrivateKeyAccessRight(index, password);
            ret = this.sdfApi.internalDecryptEcc(this.ses[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
            this.checkRet("internalDecryptEcc next", ret);
        } else {
            this.checkRet("internalDecryptEcc", ret);
        }
        return pucData;
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException {
        return new byte[0];
    }

    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getCipherKey();
    }

    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        int uiKeyBits_SES = 128;
        EccPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        EccCipher pucKey = new EccCipher();
        int ret = this.sdfApi.generateKeyWithEpkEcc(this.ses[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        this.checkRet("generateKeyWithEpkEcc", ret);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        byte[] y;
        long[] phKeyHandle = new long[]{0L};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getX());
        EccCipher pucKey = new EccCipher(x, y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getY()), sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        int ret = this.sdfApi.importKeyWithIskEcc(this.ses[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == 0x1000007) {
            this.release();
            this.init();
            this.getPrivateKeyAccessRight(uiIskIndex, password);
            ret = this.sdfApi.importKeyWithIskEcc(this.ses[0], uiIskIndex, pucKey, phKeyHandle);
            this.checkRet("internalSignECC next", ret);
        } else {
            this.checkRet("internalSignECC", ret);
        }
        this.checkRet("importKeyWithIskEcc", ret);
        return phKeyHandle;
    }

    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        int ret = this.sdfApi.importKey(this.ses[0], pucKey, pucKey.length, phKeyHandle);
        this.checkRet("importKey", ret);
        return phKeyHandle;
    }

    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = new int[]{pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        int ret = this.sdfApi.encrypt(this.ses[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        this.checkRet("encrypt", ret);
        return pucEncData;
    }

    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = new int[]{pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        int ret = this.sdfApi.decrypt(this.ses[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        this.checkRet("decrypt", ret);
        return pucData;
    }

    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        int ret = this.sdfApi.destroyKey(this.ses[0], phKeyHandle[0]);
        this.checkRet("destroyKey", ret);
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        int ret = this.sdfApi.hashInit(this.ses[0], sdfAlgIdHash.getId(), null, null, 0);
        this.checkRet("hashInit", ret);
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        EccPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        int ret = this.sdfApi.hashInit(this.ses[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        this.checkRet("hashInit", ret);
    }

    public void hashUpdate(byte[] data) throws SdfSDKException {
        int ret = this.sdfApi.hashUpdate(this.ses[0], data, data.length);
        this.checkRet("hashUpdate", ret);
    }

    public byte[] hashFinal(int digestLen) throws SdfSDKException {
        byte[] pucHash = new byte[digestLen];
        int[] pucHashLen = new int[]{pucHash.length};
        int ret = this.sdfApi.hashFinal(this.ses[0], pucHash, pucHashLen);
        this.checkRet("hashFinal", ret);
        return pucHash;
    }

    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int uiKeyBits_SES = 128;
        long[] phKeyHandle = new long[]{0L};
        EccCipher pucKey = new EccCipher();
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = new int[]{1024};
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();
        int ret = this.sdfApi.generateKeyWithIpkEcc(this.ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        this.checkRet("generateKeyWithIpkEcc", ret);
        ret = this.sdfApi.calculateMac(this.ses[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        this.checkRet("calculateMac", ret);
    }

    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        byte[] mac = new byte[32];
        int ret = this.sdfApi.sm3Hmac(this.ses[0], dataIn, dataIn.length, key, key.length, mac);
        this.checkRet("sm3HmacDemo", ret);
        return mac;
    }

    public void getDeviceInfo() throws SdfSDKException {
        DeviceInfo devinfo = new DeviceInfo();
        int ret = this.sdfApi.getDeviceInfo(this.ses[0], devinfo);
        this.checkRet("getDeviceInfo", ret);
        System.out.println(devinfo.toString());
    }

    public SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException {
        return null;
    }

    public SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException {
        return null;
    }

    public SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException {
        return null;
    }

    public byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException {
        return new byte[0];
    }

    public byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException {
        return new byte[0];
    }

    public byte[] encryptAead(long[] phKeyHandle, int uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException {
        return new byte[0];
    }

    public byte[] decryptAead(long[] phKeyHandle, int uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException {
        return new byte[0];
    }
}

