package com.xdja.pcie.base;

import java.io.Serializable;
import java.util.Arrays;

/**
 * RSA私钥数据实体定义
 * @author wyf
 *
 */
public class RSAPrivateKey implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 模长
	 */
	private int bits;
	/**
	 * 模N
	 */
	private byte[] m = new byte[RSAPublicKey.RSA_MAX_LEN];
	/**
	 * 公钥指数
	 */
	private byte[] e = new byte[RSAPublicKey.RSA_MAX_LEN];
	/**
	 * 私钥指数
	 */
	private byte[] d = new byte[RSAPublicKey.RSA_MAX_LEN];
	/**
	 * 素数P和q
	 */
	private byte[][] prime = new byte[2][RSAPublicKey.RSA_MAX_PLEN];
	/**
	 * Dp和Dq
	 */
	private byte[][] pexp = new byte[2][RSAPublicKey.RSA_MAX_PLEN];
	/**
	 * 系数i
	 */
	private byte[] coef = new byte[RSAPublicKey.RSA_MAX_PLEN];

	public RSAPrivateKey() {
		super();
	}

	public RSAPrivateKey(int bits, byte[] m, byte[] e, byte[] d, byte[][] prime, byte[][] pexp, byte[] coef) {
		super();
		this.bits = bits;
		this.m = m;
		this.e = e;
		this.d = d;
		this.prime = prime;
		this.pexp = pexp;
		this.coef = coef;
	}

	/**
	 * 获得 bits
	 * @return bits 参见 {@linkplain #bits} 
	 */
	public int getBits() {
		return bits;
	}

	/**
	 * 设置 bits
	 * @param bits 参见 {@linkplain #bits}
	 */
	public void setBits(int bits) {
		this.bits = bits;
	}

	/**
	 * 获得 m
	 * @return m 参见 {@linkplain #m} 
	 */
	public byte[] getM() {
		return m;
	}

	/**
	 * 设置 m
	 * @param m 参见 {@linkplain #m}
	 */
	public void setM(byte[] m) {
		this.m = m;
	}

	/**
	 * 获得 e
	 * @return e 参见 {@linkplain #e} 
	 */
	public byte[] getE() {
		return e;
	}

	/**
	 * 设置 e
	 * @param e 参见 {@linkplain #e}
	 */
	public void setE(byte[] e) {
		this.e = e;
	}

	/**
	 * 获得 d
	 * @return d 参见 {@linkplain #d} 
	 */
	public byte[] getD() {
		return d;
	}

	/**
	 * 设置 d
	 * @param d 参见 {@linkplain #d}
	 */
	public void setD(byte[] d) {
		this.d = d;
	}

	/**
	 * 获得 prime
	 * @return prime 参见 {@linkplain #prime} 
	 */
	public byte[][] getPrime() {
		return prime;
	}

	/**
	 * 设置 prime
	 * @param prime 参见 {@linkplain #prime}
	 */
	public void setPrime(byte[][] prime) {
		this.prime = prime;
	}

	/**
	 * 获得 pexp
	 * @return pexp 参见 {@linkplain #pexp} 
	 */
	public byte[][] getPexp() {
		return pexp;
	}

	/**
	 * 设置 pexp
	 * @param pexp 参见 {@linkplain #pexp}
	 */
	public void setPexp(byte[][] pexp) {
		this.pexp = pexp;
	}

	/**
	 * 获得 coef
	 * @return coef 参见 {@linkplain #coef} 
	 */
	public byte[] getCoef() {
		return coef;
	}

	/**
	 * 设置 coef
	 * @param coef 参见 {@linkplain #coef}
	 */
	public void setCoef(byte[] coef) {
		this.coef = coef;
	}

	@Override
	public String toString() {
		return "RSAPrivateKey [bits=" + bits + ", m=" + Arrays.toString(m) + ", e=" + Arrays.toString(e) + ", d="
				+ Arrays.toString(d) + ", prime=" + Arrays.toString(prime) + ", pexp=" + Arrays.toString(pexp)
				+ ", coef=" + Arrays.toString(coef) + "]";
	}

}
