package com.xdja.pki.gmssl.sdf.pcie.pool;

import com.xdja.pcie.SDFAPI;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName PciePooledObjectFactory
 * @Description TODO
 * @Date 2020/5/18 20:04
 * @Author FengZhen
 */
public class PciePooledObjectFactory implements PooledObjectFactory<PcieConnection> {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private volatile SDFAPI sdfApi = new SDFAPI();
    private volatile long[] dev = {0};

    PciePooledObjectFactory() {
        openDevice();
    }

    synchronized boolean isDeviceOpen() {
        return this.dev[0] != 0;
    }

    synchronized void openDevice() {
        if (!isDeviceOpen()) {
            try {
                PcieSdfSDKUtils.openDevice(this.sdfApi, this.dev);
            } catch (SdfSDKException e) {
                logger.error("hsm pool init openDevice error", e);
            }
            logger.debug("openDevice dev = {} session = {}", dev[0]);

        } else {
            logger.error("hsm pool open device but dev={}", dev[0]);
        }

    }

    synchronized void closeDevice() {
        if (this.dev[0] != 0) {
            try {
                PcieSdfSDKUtils.closeDevice(this.sdfApi, this.dev);
                logger.debug("closeDevice dev = {} session = {}", dev[0]);
            } catch (SdfSDKException e) {
                logger.error("hsm pool init closeDevice error", e);
            }
        }
        this.dev = new long[]{0};
    }

    @Override
    public PooledObject<PcieConnection> makeObject() throws Exception {
        if (this.dev[0] == 0) {
            logger.error("make hsm connection device is not open! now open it!");
            openDevice();
        }
        PcieConnection connection = new PcieConnection(this.sdfApi, this.dev);
        return new DefaultPooledObject<>(connection);
    }

    @Override
    public void destroyObject(PooledObject<PcieConnection> pooledObject) throws Exception {
        PcieConnection connection = pooledObject.getObject();
        if (connection.isConnection()) {
            connection.close();
        }
    }

    @Override
    public boolean validateObject(PooledObject<PcieConnection> pooledObject) {
        PcieConnection connection = pooledObject.getObject();
        return connection.isConnection();
    }

    @Override
    public void activateObject(PooledObject<PcieConnection> pooledObject) throws Exception {

    }

    @Override
    public void passivateObject(PooledObject<PcieConnection> pooledObject) throws Exception {

    }

}
