/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieSdfSDKDemo {
    private static Logger logger = LoggerFactory.getLogger((String)PcieSdfSDKDemo.class.getName());
    private static byte[] pwd = "xdja1234".getBytes();
    private static int sm2Index = 2;

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. getinfo. exportenc. exportsign. random, sm1enc. gensm2key.  sm2sign. sm2enc. sm4enc. sm3hash. sm3hmac. sm4mac,sm2signTest,sm2encTest");
            return;
        }
        System.out.println("You want to test: " + args[0]);
        PcieSdfSDK sdfSDK = new PcieSdfSDK();
        switch (args[0]) {
            case "all": {
                System.out.println("*************** getDeviceInfo ***************");
                PcieSdfSDKDemo.getDeviceInfo(sdfSDK);
                System.out.println("*************** random ***************");
                PcieSdfSDKDemo.random(sdfSDK);
                System.out.println("*************** generateKeyPairEcc ***************");
                sdfSDK.generateKeyPairEcc();
                System.out.println("*************** exportsign ***************");
                PcieSdfSDKDemo.exportSignKey(sdfSDK, args);
                System.out.println("*************** exportenc ***************");
                PcieSdfSDKDemo.exportEncKey(sdfSDK, args);
                System.out.println("*************** sm2SignDemo ***************");
                PcieSdfSDKDemo.sm2SignDemo(sdfSDK);
                System.out.println("*************** sm2EncDemo ***************");
                PcieSdfSDKDemo.sm2EncDemo(sdfSDK);
                System.out.println("*************** sm4EncDemo ***************");
                PcieSdfSDKDemo.sm4EncDemo(sdfSDK);
                System.out.println("*************** sm3HashDemoWithPublicKey ***************");
                PcieSdfSDKDemo.sm3HashDemoWithPublicKey(sdfSDK);
                System.out.println("*************** sm3HashDemo ***************");
                PcieSdfSDKDemo.sm3HashDemo(sdfSDK);
                System.out.println("*************** sm3HmacDemo ***************");
                PcieSdfSDKDemo.sm3HmacDemo(sdfSDK);
                System.out.println("*************** sm4MacDemo ***************");
                PcieSdfSDKDemo.sm4MacDemo(sdfSDK);
                break;
            }
            case "getinfo": {
                PcieSdfSDKDemo.getDeviceInfo(sdfSDK);
                break;
            }
            case "random": {
                PcieSdfSDKDemo.random(sdfSDK);
                break;
            }
            case "gensm2key": {
                PcieSdfSDKDemo.generateKeyPairEcc(sdfSDK);
                break;
            }
            case "exportsign": {
                PcieSdfSDKDemo.exportSignKey(sdfSDK, args);
                break;
            }
            case "exportenc": {
                PcieSdfSDKDemo.exportEncKey(sdfSDK, args);
                break;
            }
            case "sm1enc": {
                PcieSdfSDKDemo.sm1EncDemo(sdfSDK);
                break;
            }
            case "sm2sign": {
                PcieSdfSDKDemo.sm2SignDemo(sdfSDK);
                break;
            }
            case "sm2enc": {
                PcieSdfSDKDemo.sm2EncDemo(sdfSDK);
                break;
            }
            case "sm4enc": {
                PcieSdfSDKDemo.sm4EncDemo(sdfSDK);
                break;
            }
            case "sm3hash": {
                System.out.println("*************** sm3HashDemoWithPublicKey ***************");
                PcieSdfSDKDemo.sm3HashDemoWithPublicKey(sdfSDK);
                System.out.println("*************** sm3HashDemo ***************");
                PcieSdfSDKDemo.sm3HashDemo(sdfSDK);
                break;
            }
            case "sm3hmac": {
                PcieSdfSDKDemo.sm3HmacDemo(sdfSDK);
                break;
            }
            case "sm4mac": {
                PcieSdfSDKDemo.sm4MacDemo(sdfSDK);
                break;
            }
            case "sm2signTest": {
                PcieSdfSDKDemo.sm2SignDemoTest(sdfSDK);
                break;
            }
            case "sm2encTest": {
                PcieSdfSDKDemo.sm2EncDemoTest(sdfSDK);
                break;
            }
            default: {
                System.out.println("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\uff01");
            }
        }
    }

    private static void getDeviceInfo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        logger.info("*************** getDeviceInfo ***************");
        sdfSDK.init();
        sdfSDK.getDeviceInfo();
        sdfSDK.release();
    }

    private static void exportSignKey(PcieSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        logger.info("*************** exportSM2Key ***************");
        sdfSDK.init();
        int index = sm2Index;
        try {
            index = Integer.valueOf(args[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(index);
        SdfECCPublicKey signPublicKeyEcc = sdfSDK.exportSignPublicKeyEcc(index);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"signPublicKeyEcc getX()", (byte[])signPublicKeyEcc.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"signPublicKeyEcc getY()", (byte[])signPublicKeyEcc.getY());
        sdfSDK.release();
    }

    private static void exportEncKey(PcieSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        logger.info("*************** exportSM2Key ***************");
        sdfSDK.init();
        int index = sm2Index;
        try {
            index = Integer.valueOf(args[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(index);
        SdfECCPublicKey eccPublicKey = sdfSDK.exportEncPublicKeyEcc(index);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"eccPublicKey getX()", (byte[])eccPublicKey.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"eccPublicKey getY()", (byte[])eccPublicKey.getY());
        sdfSDK.release();
    }

    private static void generateKeyPairEcc(PcieSdfSDK sdfSDK) throws SdfSDKException {
        logger.info("*************** generateKeyPairEccDemo ***************");
        sdfSDK.init();
        SdfECCKeyPair sdfECCKeyPair = sdfSDK.generateKeyPairEcc();
        SdfECCPublicKey sdfECCPublicKey = sdfECCKeyPair.getSdfECCPublicKey();
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"SdfECCPublicKey getX  ", (byte[])sdfECCPublicKey.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"SdfECCPublicKey getY  ", (byte[])sdfECCPublicKey.getY());
        sdfSDK.release();
    }

    private static void random(PcieSdfSDK sdfSDK) throws SdfSDKException {
        logger.info("*************** randomDemo ***************");
        sdfSDK.init();
        int len = 28;
        byte[] out = sdfSDK.generateRandom(len);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"generateRandom out", (byte[])out);
        sdfSDK.release();
    }

    public static void sm1EncDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] cipher = GMSSLByteArrayUtils.hexDecode((String)"9203a010b50c4e3ca2897308a9d48c2e");
        logger.info(" sm1 CBC encrypt demo ");
        PcieSdfSDKDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM1_CBC, key, data, cipher);
        logger.info(" sm1 ECB encrypt demo ");
        PcieSdfSDKDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM1_ECB, key, data, cipher);
    }

    private static void sm2SignDemoTest(PcieSdfSDK sdfSDK) throws SdfSDKException, NoSuchProviderException, KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, CertificateException {
        logger.info("*************** sm2SignDemoTest ***************");
        sdfSDK.init();
        byte[] data = "12345678123456781234567812345678".getBytes();
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        sdfSDK.checkPrivateKeyAccessRight(sm2Index, pwd);
        SdfECCSignature sdfECCSignature = sdfSDK.internalSignECC(sm2Index, pwd, data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"sdf sign r", (byte[])sdfECCSignature.getR());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"sdf sign s", (byte[])sdfECCSignature.getS());
        SdfECCPublicKey sdfECCPublicKey = sdfSDK.exportSignPublicKeyEcc(sm2Index);
        sdfSDK.externalVerifyECC(sdfECCPublicKey, data, sdfECCSignature);
        logger.info("sm2Sign is success");
        sdfSDK.releasePrivateKeyAccessRight(sm2Index);
        sdfSDK.release();
    }

    private static void sm2SignDemo(PcieSdfSDK sdfSDK) throws SdfSDKException, NoSuchProviderException, KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, CertificateException {
        logger.info("*************** sm2SignDemo ***************");
        sdfSDK.init();
        byte[] data = "12345678123456781234567812345678".getBytes();
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        sdfSDK.importSM2PublicKey(keyPair.getPublic(), sm2Index, true);
        sdfSDK.importSM2PrivateKey(keyPair.getPrivate(), sm2Index, true);
        sdfSDK.checkPrivateKeyAccessRight(sm2Index, pwd);
        SdfECCSignature sdfECCSignature = sdfSDK.internalSignECC(sm2Index, pwd, data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"sdf sign r", (byte[])sdfECCSignature.getR());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"sdf sign s", (byte[])sdfECCSignature.getS());
        SdfECCPublicKey sdfECCPublicKey = sdfSDK.exportSignPublicKeyEcc(sm2Index);
        sdfSDK.externalVerifyECC(sdfECCPublicKey, data, sdfECCSignature);
        logger.info("sm2Sign is success");
        sdfSDK.releasePrivateKeyAccessRight(sm2Index);
        sdfSDK.release();
    }

    private static void sm2EncDemoTest(PcieSdfSDK sdfSDK) throws Exception {
        logger.info("*************** sm2EncDemoTest ***************");
        sdfSDK.init();
        byte[] data = "12345678123456781234567812345678".getBytes();
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        SdfECCPublicKey sdfECCPublicKey = sdfSDK.exportEncPublicKeyEcc(sm2Index);
        SdfECCCipher sdfECCCipher = sdfSDK.externalEncryptECC(sdfECCPublicKey, data);
        sdfSDK.checkPrivateKeyAccessRight(sm2Index, pwd);
        byte[] plaintext = sdfSDK.internalDecryptECC(sm2Index, pwd, sdfECCCipher.getC().length, sdfECCCipher);
        sdfSDK.releasePrivateKeyAccessRight(sm2Index);
        sdfSDK.release();
        if (Arrays.equals(plaintext, data)) {
            logger.info("decrypt data is equals with plain data");
        } else {
            logger.error("decrypt data is not equals with plain data");
        }
    }

    private static void sm2EncDemo(PcieSdfSDK sdfSDK) throws Exception {
        logger.info("*************** sm2EncDemo ***************");
        sdfSDK.init();
        byte[] data = "12345678123456781234567812345678".getBytes();
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        sdfSDK.importSM2PublicKey(keyPair.getPublic(), sm2Index, false);
        sdfSDK.importSM2PrivateKey(keyPair.getPrivate(), sm2Index, false);
        SdfECCPublicKey sdfECCPublicKey = sdfSDK.exportEncPublicKeyEcc(sm2Index);
        SdfECCCipher sdfECCCipher = sdfSDK.externalEncryptECC(sdfECCPublicKey, data);
        sdfSDK.checkPrivateKeyAccessRight(sm2Index, pwd);
        byte[] plaintext = sdfSDK.internalDecryptECC(sm2Index, pwd, sdfECCCipher.getC().length, sdfECCCipher);
        sdfSDK.releasePrivateKeyAccessRight(sm2Index);
        sdfSDK.release();
        if (Arrays.equals(plaintext, data)) {
            logger.info("decrypt data is equals with plain data");
        } else {
            logger.error("decrypt data is not equals with plain data");
        }
    }

    public static void sm4EncDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] cipher = GMSSLByteArrayUtils.hexDecode((String)"681edf34d206965e86b3e94f536e4246");
        logger.info(" sm4 CBC encrypt demo ");
        PcieSdfSDKDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM4_CBC, key, data, cipher);
        logger.info(" sm4 ECB encrypt demo ");
        PcieSdfSDKDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM4_ECB, key, data, cipher);
    }

    public static void sm3HashDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        sdfSDK.hashUpdate("111".getBytes());
        byte[] out = sdfSDK.hashFinal(32);
        sdfSDK.release();
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"out", (byte[])out);
    }

    public static void sm3HashDemoWithPublicKey(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] xa = GMSSLByteArrayUtils.hexDecode((String)"09F9DF31 1E5421A1 50DD7D16 1E4BC5C6 72179FAD 1833FC07 6BB08FF3 56F35020");
        byte[] ya = GMSSLByteArrayUtils.hexDecode((String)"CCEA490C E26775A5 2DC6EA71 8CC1AA60 0AED05FB F35E084A 6632F607 2DA9AD13");
        byte[] ID_A = Strings.toByteArray((String)"1234567812345678");
        byte[] msg = Strings.toByteArray((String)"message digest");
        byte[] expecteds = GMSSLByteArrayUtils.hexDecode((String)"F0B43E94 BA45ACCA ACE692ED 534382EB 17E6AB5A 19CE7B31 F4486FDF C0D28640");
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"xa", (byte[])xa);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"ya", (byte[])ya);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"ID_A", (byte[])ID_A);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"message digest", (byte[])msg);
        sdfSDK.init();
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3, ID_A, SdfECCPublicKey.getInstance((BigInteger)new BigInteger(xa), (BigInteger)new BigInteger(ya)));
        sdfSDK.hashUpdate(msg);
        byte[] actuals = sdfSDK.hashFinal(32);
        sdfSDK.release();
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"expecteds", (byte[])expecteds);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"actuals", (byte[])actuals);
        if (Arrays.equals(expecteds, actuals)) {
            logger.info("expecteds data is equals with actuals data");
        } else {
            logger.error("expecteds data is not equals with actuals data");
        }
    }

    public static void sm3HmacDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] key = "12345678123456781234567812345678".getBytes();
        byte[] mac = sdfSDK.sm3Hmac(data, key);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"sdfSDK.sm3Hmac", (byte[])mac);
        sdfSDK.release();
    }

    public static void sm4MacDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        sdfSDK.calculateMac(1);
        sdfSDK.release();
    }

    private static void symmetricEncDemo(PcieSdfSDK sdfSDK, SdfAlgIdSymmetric symmetric, byte[] key, byte[] data, byte[] cipher) throws SdfSDKException {
        sdfSDK.init();
        long[] handle = sdfSDK.importKey(key);
        byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"00000000000000000000000000000000");
        byte[] c = sdfSDK.encrypt(handle, symmetric, iv, data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"encrypt c", (byte[])c);
        byte[] p = sdfSDK.decrypt(handle, symmetric, iv, c);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"decrypt p", (byte[])p);
        if (Arrays.equals(data, p)) {
            logger.info("decrypt data is equals with plain data");
        } else {
            logger.error("decrypt data is not equals with plain data");
        }
        if (Arrays.equals(cipher, c)) {
            logger.info("encrypt data is equals with expect cipher data");
        } else {
            logger.error("encrypt data is not equals with expect cipher data");
        }
        sdfSDK.release();
    }
}

