/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie.pool;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnection;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionPrivoider;
import com.xdja.pki.gmssl.sdf.pcie.pool.PciePooledObjectFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieConnectionProviderImpl
implements PcieConnectionPrivoider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private GenericObjectPool<PcieConnection> genericObjectPool;
    private volatile PciePooledObjectFactory factory = new PciePooledObjectFactory();

    private PcieConnectionProviderImpl() {
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.factory);
        this.initPool();
    }

    private void initPool() {
        int maxTotal = 200;
        int maxIdle = 100;
        int minIdle = 30;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (element.getClassName().startsWith("org.junit.")) {
                maxTotal = 8;
                maxIdle = 2;
                minIdle = 1;
            }
            if (!element.getClassName().startsWith("com.xdja.pki.gmssl.main.")) continue;
            maxTotal = 1;
            maxIdle = 1;
            minIdle = 1;
        }
        String property = System.getProperty("catalina.home");
        File hsmCfg = new File(property + "/conf/hsm.conf");
        this.logger.error("INFO init connection pool: config={} ", (Object)hsmCfg);
        if (hsmCfg.exists()) {
            try {
                byte[] bytes = GMSSLFileUtils.readFileToByte((String)hsmCfg.getAbsolutePath());
                String cfg = new String(bytes);
                cfg = cfg.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\r\n", "");
                String[] cfgs = cfg.split("-");
                maxTotal = Integer.valueOf(cfgs[0]);
                maxIdle = Integer.valueOf(cfgs[1]);
                minIdle = Integer.valueOf(cfgs[2]);
            }
            catch (IOException e) {
                this.logger.error("read hsm.conf error! {}", (Throwable)e);
            }
        }
        this.logger.error("INFO init connection pool: setMaxTotal={} setMaxIdle={} setMinIdle={}", new Object[]{maxTotal, maxIdle, minIdle});
        this.genericObjectPool.setMaxTotal(maxTotal);
        this.genericObjectPool.setMaxIdle(maxIdle);
        this.genericObjectPool.setMinIdle(minIdle);
        if (this.factory.isDeviceOpen()) {
            try {
                this.logger.error("INFO init connection pool: prepare hsm connection pool minIdle={}", (Object)minIdle);
                this.genericObjectPool.preparePool();
            }
            catch (Exception e) {
                this.logger.error("INFO init connection pool: prepare hsm connection pool error {}", (Throwable)e);
            }
        }
        this.logger.error("INFO init connection pool: getMaxTotal={} getMaxIdle={} getMinIdle={} getNumIdle={} getCreatedCount={}", new Object[]{this.genericObjectPool.getMaxTotal(), this.genericObjectPool.getMaxIdle(), this.genericObjectPool.getMinIdle(), this.genericObjectPool.getNumIdle(), this.genericObjectPool.getCreatedCount()});
    }

    @Override
    public PcieConnection getConnection() {
        try {
            if (this.genericObjectPool.getNumWaiters() > 0) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String methodName = stackTrace[2].getMethodName();
                this.logger.info("get connection pool: {} getNumIdle={} getNumActive={} getNumWaiters={} getCreatedCount={} getBorrowedCount={} getReturnedCount={}", new Object[]{methodName, this.genericObjectPool.getReturnedCount(), this.genericObjectPool.getNumActive(), this.genericObjectPool.getNumWaiters(), this.genericObjectPool.getCreatedCount(), this.genericObjectPool.getBorrowedCount(), this.genericObjectPool.getReturnedCount()});
            }
            return (PcieConnection)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            this.logger.error("getConnection error", (Throwable)e);
            throw new RuntimeException("getConnection error", e);
        }
    }

    @Override
    public void releaseConnection(PcieConnection connection) {
        try {
            this.genericObjectPool.returnObject((Object)connection);
            if (this.genericObjectPool.getNumWaiters() > 0) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String methodName = stackTrace[3].getMethodName();
                this.logger.info("release connection pool: {} getNumIdle={} getNumActive={} getNumWaiters={} getCreatedCount={} getBorrowedCount={} getReturnedCount={}", new Object[]{methodName, this.genericObjectPool.getReturnedCount(), this.genericObjectPool.getNumActive(), this.genericObjectPool.getNumWaiters(), this.genericObjectPool.getCreatedCount(), this.genericObjectPool.getBorrowedCount(), this.genericObjectPool.getReturnedCount()});
            }
        }
        catch (Exception e) {
            this.logger.error("releaseConnection error", (Throwable)e);
            throw new RuntimeException("releaseConnection error", e);
        }
    }

    public synchronized void clear() {
        this.genericObjectPool.clear();
        this.factory.closeDevice();
    }

    public synchronized void reopen() throws Exception {
        this.clear();
        this.factory.openDevice();
        this.genericObjectPool.preparePool();
    }

    public static synchronized PcieConnectionProviderImpl getInstance() {
        return ConnectionProviderHolder.INSTANCE;
    }

    private static class ConnectionProviderHolder {
        private static final PcieConnectionProviderImpl INSTANCE = new PcieConnectionProviderImpl();

        private ConnectionProviderHolder() {
        }
    }
}

