/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.base.DeviceInfo;
import com.xdja.pcie.base.ECCCipher;
import com.xdja.pcie.base.ECCPrivateKey;
import com.xdja.pcie.base.ECCPublicKey;
import com.xdja.pcie.base.ECCSignature;
import com.xdja.pcie.base.RSAPrivateKey;
import com.xdja.pcie.base.RSAPublicKey;
import com.xdja.pcie.sdf.jni.alg.AlgId;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdAead;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRsaKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfSymmetricKeyHandle;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnection;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieSdfSDK
extends AbstractSdfSDK {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PcieConnection connection;

    public void init() throws SdfSDKException {
    }

    public void release() throws SdfSDKException {
    }

    public void releaseConnection() {
        if (this.connection != null) {
            PcieConnectionProviderImpl.getInstance().releaseConnection(this.connection);
            this.connection = null;
        }
    }

    protected void checkRet(String method, int ret, boolean release) throws SdfSDKException {
        long dev = this.connection.getDev()[0];
        long ses = this.connection.getSes()[0];
        if (release || ret != 0) {
            this.releaseConnection();
        }
        PcieSdfSDKUtils.checkRet(method, ret, dev, ses);
    }

    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateRandom(this.connection.getSes()[0], uiLength, pucRandom);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateRandom(this.connection.getSes()[0], uiLength, pucRandom);
        }
        this.checkRet("generateRandom uiLength " + uiLength, ret, true);
        return pucRandom;
    }

    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        return this.generateKeyPairEcc(AlgId.SGD_SM2);
    }

    public SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException {
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        ECCPrivateKey pucPrivateKey = new ECCPrivateKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyPairECC(this.connection.getSes()[0], algId, 256, pucPublicKey, pucPrivateKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyPairECC(this.connection.getSes()[0], algId, 256, pucPublicKey, pucPrivateKey);
        }
        this.checkRet("generateKeyPairEcc", ret, true);
        this.logger.info("public key x :" + Hex.toHexString((byte[])pucPublicKey.getX()));
        this.logger.info("public key y :" + Hex.toHexString((byte[])pucPublicKey.getY()));
        this.logger.info("private key x :" + Hex.toHexString((byte[])pucPrivateKey.getK()));
        return new SdfECCKeyPair(SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY()), SdfECCPrivateKey.getInstanceFilterFoot((byte[])pucPrivateKey.getK()));
    }

    public boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        boolean result = false;
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().getPrivateKeyAccessRight(this.connection.getSes()[0], index, password, password.length);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().getPrivateKeyAccessRight(this.connection.getSes()[0], index, password, password.length);
        }
        this.releaseConnection();
        if (ret == 0) {
            result = true;
        }
        return result;
    }

    public void releasePrivateKeyAccessRight(int index) throws SdfSDKException {
        int ret = this.connection.getSdfApi().releasePrivateKeyAccessRight(this.connection.getSes()[0], index);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().releasePrivateKeyAccessRight(this.connection.getSes()[0], index);
        }
        this.checkRet("releasePrivateKeyAccessRight", ret, false);
    }

    private void getPrivateKeyAccessRight(PcieConnection connection, int index, byte[] password) throws SdfSDKException {
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == 0x1000003) {
            connection.reopen();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
        if (ret == 0x1000018) {
            this.logger.debug("getPrivateKeyAccessRight fail password may be wrong, index={} password={}", (Object)index, (Object)new String(password));
            return;
        }
        this.checkRet("getPrivateKeyAccessRight", ret, false);
    }

    private void releasePrivateKeyAccessRight(PcieConnection connection, int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == 0x1000003) {
            connection.reopen();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        this.checkRet("releasePrivateKeyAccessRight", ret, false);
    }

    public void importSM2PublicKey(PublicKey key, int index, boolean isSign) throws SdfSDKException {
        this.logger.info("\u5bfc\u5165SM2\u516c\u94a5\u5f00\u59cb");
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.logger.info("\u83b7\u53d6\u5230connection");
        String method = isSign ? "sm2ImportSignpub" : "sm2ImportEncpub";
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, key);
        int ret = isSign ? this.connection.getSdfApi().SM2ImportSignpub(this.connection.getSes()[0], index, pucPublicKey) : this.connection.getSdfApi().SM2ImportEncpub(this.connection.getSes()[0], index, pucPublicKey);
        this.checkRet(method, ret, true);
        ECCPublicKey ecPublicKey_exp = new ECCPublicKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        ret = isSign ? this.connection.getSdfApi().exportSignPublicKeyECC(this.connection.getSes()[0], index, ecPublicKey_exp) : this.connection.getSdfApi().exportEncPublicKeyECC(this.connection.getSes()[0], index, ecPublicKey_exp);
        this.logger.info("\u5bfc\u5165\u6210\u529f");
        this.checkRet("exportSignPublicKeyEcc", ret, true);
    }

    public void importSM2PrivateKey(PrivateKey key, int index, byte[] password, boolean isSign) throws SdfSDKException {
        String method = isSign ? "sm2ImportSignpri" : "sm2ImportEncpri";
        ECCPrivateKey pucPrivateKey = PcieSdfSDKUtils.generateEccPrivateKey(this.logger, key);
        this.logger.info("\u5bfc\u5165SM2\u79c1\u94a5\u5f00\u59cb");
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.connection.getSdfApi().getPrivateKeyAccessRight(this.connection.getSes()[0], index, password, password.length);
        this.logger.info("\u83b7\u53d6\u5230connection");
        int ret = isSign ? this.connection.getSdfApi().SM2ImportSignpri(this.connection.getSes()[0], index, pucPrivateKey, 0) : this.connection.getSdfApi().SM2ImportEncpri(this.connection.getSes()[0], index, pucPrivateKey, 0);
        this.logger.info("\u5bfc\u5165\u6210\u529f");
        this.checkRet(method, ret, true);
    }

    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        ECCSignature pucSignature = new ECCSignature();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = this.connection.getSdfApi().internalSignECC(this.connection.getSes()[0], index, data, data.length, pucSignature);
        if (ret == 0x1000003) {
            this.connection.reopen();
            this.getPrivateKeyAccessRight(this.connection, index, password);
            ret = this.connection.getSdfApi().internalSignECC(this.connection.getSes()[0], index, data, data.length, pucSignature);
        }
        this.checkRet("internalSignECC", ret, true);
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportSignPublicKeyECC(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportSignPublicKeyECC(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportSignPublicKeyEcc", ret, true);
        return SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        this.externalVerifyECC(publicKey, data, sdfECCSignature, "SM3WITHSM2");
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException {
        int algId;
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCSignature.getS());
        ECCSignature pucSignature = new ECCSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])publicKey.getY());
        ECCPublicKey pucPublicKey = new ECCPublicKey(256, x, y);
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        if (signAlgName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (signAlgName.toUpperCase().contains("ECDSA")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support the signAlgName " + signAlgName);
        }
        int ret = this.connection.getSdfApi().externalVerifyECC(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().externalVerifyECC(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        }
        this.checkRet("externalVerifyECC", ret, true);
    }

    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportEncPublicKeyECC(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportEncPublicKeyECC(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportEncPublicKeyEcc index " + index, ret, true);
        return SdfECCPublicKey.getInstanceFilterFoot((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException {
        return this.externalEncryptECC(publicKey, data, "SM2");
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey sdfECCPublicKey, byte[] data, String stdName) throws SdfSDKException {
        int algId;
        ECCCipher pucEncData = new ECCCipher();
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey.getX(), sdfECCPublicKey.getY());
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support stdName " + stdName);
        }
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().externalEncryptECC(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().externalEncryptECC(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        }
        this.checkRet("externalEncryptECC", ret, true);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        return this.internalDecryptECC(index, password, len, sdfECCCipher, "SM2");
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException {
        int algId;
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getY());
        ECCCipher pucEncData = new ECCCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = new int[]{len};
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support the stdName " + stdName);
        }
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = this.connection.getSdfApi().internalDecryptECC(this.connection.getSes()[0], algId, index, pucEncData, pucData, puiDataLength);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().internalDecryptECC(this.connection.getSes()[0], algId, index, pucEncData, pucData, puiDataLength);
        }
        this.checkRet("internalDecryptEcc index " + index + " password " + new String(password), ret, true);
        return pucData;
    }

    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        this.destroyKey(keyHandle.getHandle());
        return keyHandle.getCipherKey();
    }

    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        int uiKeyBits_SES = 128;
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        ECCCipher pucKey = new ECCCipher();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyWithEPKECC(this.connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyWithEPKECC(this.connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        }
        this.checkRet("generateKeyWithEPKECC", ret, false);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfECCCipher.getY());
        ECCCipher pucKey = new ECCCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, uiIskIndex, password);
        int ret = this.connection.getSdfApi().importKeyWithISKECC(this.connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().importKeyWithISKECC(this.connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
        this.checkRet("importKeyWithIskEcc index " + uiIskIndex + " password " + new String(password), ret, false);
        return phKeyHandle;
    }

    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().ImportKey(this.connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().ImportKey(this.connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        }
        this.checkRet("importKey", ret, false);
        return phKeyHandle;
    }

    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        int ret;
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = new int[]{pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        if ((ret = this.connection.getSdfApi().encrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength)) == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().encrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        }
        this.checkRet("encrypt", ret, false);
        return pucEncData;
    }

    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        int ret;
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = new int[]{pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        if ((ret = this.connection.getSdfApi().decrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength)) == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().decrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        }
        this.checkRet("decrypt", ret, false);
        return pucData;
    }

    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        if (this.connection != null) {
            int ret = this.connection.getSdfApi().destroyKey(this.connection.getSes()[0], phKeyHandle[0]);
            if (ret == 0x1000003) {
                this.logger.error("destroyKey ret={} is SDR_COMMFAIL", (Object)ret);
            }
            this.checkRet("destroyKey", ret, true);
        }
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        }
        this.checkRet("hashInit", ret, false);
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        }
        this.checkRet("hashInit pucID " + new String(pucID), ret, false);
    }

    public void hashUpdate(byte[] data) throws SdfSDKException {
        if (data.length == 0) {
            this.logger.debug("hashUpdate data length == 0");
            return;
        }
        int ret = this.connection.getSdfApi().hashUpdate(this.connection.getSes()[0], data, data.length);
        this.checkRet("hashUpdate", ret, false);
    }

    public byte[] hashFinal(int digestLen) throws SdfSDKException {
        byte[] pucHash = new byte[digestLen];
        int[] pucHashLen = new int[]{pucHash.length};
        if (this.connection != null) {
            int ret = this.connection.getSdfApi().hashFinal(this.connection.getSes()[0], pucHash, pucHashLen);
            if (ret == 0x1000003) {
                this.logger.error("hashFinal ret={} is SDR_COMMFAIL", (Object)ret);
            }
            this.checkRet("hashFinal digestLen " + digestLen, ret, true);
        }
        return pucHash;
    }

    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int uiKeyBits_SES = 128;
        long[] phKeyHandle = new long[]{0L};
        ECCCipher pucKey = new ECCCipher();
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = new int[]{1024};
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyWithIPKECC(this.connection.getSes()[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        this.checkRet("generateKeyWithIpkEcc", ret, false);
        ret = this.connection.getSdfApi().calculateMac(this.connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().calculateMac(this.connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        }
        this.checkRet("calculateMac uiKeyIndex " + uiKeyIndex, ret, true);
    }

    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        byte[] mac = new byte[32];
        int ret = this.connection.getSdfApi().SM3HMAC(this.connection.getSes()[0], dataIn, dataIn.length, key, key.length, mac);
        this.checkRet("sm3HmacDemo", ret, true);
        return mac;
    }

    public void getDeviceInfo() throws SdfSDKException {
        DeviceInfo devinfo = new DeviceInfo();
        int ret = this.connection.getSdfApi().getDeviceInfo(this.connection.getSes()[0], devinfo);
        this.checkRet("getDeviceInfo", ret, true);
        System.out.println(devinfo.toString());
    }

    public SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException {
        RSAPublicKey pucPublicKey = new RSAPublicKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportSignPublicKeyRSA(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportSignPublicKeyRSA(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportSignPublicKeyRsa", ret, true);
        return SdfRSAPublicKey.getInstanceFilterFoot((int)pucPublicKey.getBits(), (byte[])pucPublicKey.getM(), (byte[])pucPublicKey.getE());
    }

    public SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException {
        RSAPublicKey pucPublicKey = new RSAPublicKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportEncPublicKeyRSA(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportEncPublicKeyRSA(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportEncPublicKeyRsa index " + index, ret, true);
        return SdfRSAPublicKey.getInstanceFilterFoot((int)pucPublicKey.getBits(), (byte[])pucPublicKey.getM(), (byte[])pucPublicKey.getE());
    }

    public SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException {
        RSAPublicKey rsaPublicKey = new RSAPublicKey();
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyPairRSA(this.connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyPairRSA(this.connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        }
        this.checkRet("generateKeyPairRsa bits " + bits, ret, true);
        SdfRSAPrivateKey sdfRSAPrivateKey = new SdfRSAPrivateKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE(), rsaPrivateKey.getD(), rsaPrivateKey.getPrime(), rsaPrivateKey.getPexp(), rsaPrivateKey.getCoef());
        SdfRSAPublicKey sdfRSAPublicKey = new SdfRSAPublicKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE());
        return new SdfRsaKeyPair(sdfRSAPrivateKey, sdfRSAPublicKey);
    }

    public byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException {
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = new int[]{1024};
        byte[] m = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfRSAPublicKey.getM(), (int)256);
        byte[] e = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot((byte[])sdfRSAPublicKey.getE(), (int)256);
        RSAPublicKey rsaPublicKey = new RSAPublicKey(sdfRSAPublicKey.getBits(), m, e);
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().externalPublicKeyOperationRSA(this.connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().externalPublicKeyOperationRSA(this.connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        this.checkRet("externalPublicKeyOperationRsa", ret, true);
        return pucDataOutPut;
    }

    public byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException {
        int[] puiDataOutPutLength = new int[2];
        SdfRSAPublicKey sdfRSAPublicKey = this.exportSignPublicKeyRsa(index);
        byte[] pucDataOutPut = new byte[sdfRSAPublicKey.getBits() / 8];
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = this.connection.getSdfApi().internalPrivateKeyOperationRSA(this.connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().internalPrivateKeyOperationRSA(this.connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        this.checkRet("internalPrivateKeyOperationRsa index " + index + " password " + new String(password), ret, true);
        return pucDataOutPut;
    }

    public byte[] generateKeyWithEpkRsa(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public long[] generateKeyWithEpkRsaHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public SdfSymmetricKeyHandle generateKeyWithEpkRsaKeyHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public byte[] encryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public byte[] decryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public long[] importKeyWithKek(SdfAlgIdSymmetric uiAlgId, int uiKekIndex, byte[] pucKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public long[] importKeyWithIskRsa(int uiIskIndex, byte[] password, byte[] pucKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public byte[] generateKeyWithKek(int uiAlgId, int uiKekIndex) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    public void createFile(String fileName, int fileSize) throws SdfSDKException {
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        byte[] fileNameBytes = fileName.getBytes();
        int ret = this.connection.getSdfApi().createFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length, fileSize);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().createFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length, fileSize);
        }
        this.checkRet("createFile fileName=" + fileName + " fileSize=" + fileSize, ret, true);
    }

    public byte[] readFile(String fileName, int offset, int length) throws SdfSDKException {
        byte[] fileNameBytes = fileName.getBytes();
        byte[] buffer = new byte[length];
        int[] fileLength = new int[]{length};
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().readFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, fileLength, buffer);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().readFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, fileLength, buffer);
        }
        this.checkRet("readFile fileName=" + fileName + " offset=" + offset + " length=" + length, ret, true);
        if (fileLength[0] != length) {
            byte[] out = new byte[fileLength[0]];
            System.arraycopy(buffer, 0, out, 0, fileLength[0]);
            return out;
        }
        return buffer;
    }

    public void writeFile(String fileName, int offset, byte[] context) throws SdfSDKException {
        byte[] fileNameBytes = fileName.getBytes();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().writeFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, context.length, context);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().writeFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, context.length, context);
        }
        this.checkRet("createFile fileName=" + fileName + " offset=" + offset + " contextLen=" + context.length, ret, true);
    }

    public void deleteFile(String fileName) throws SdfSDKException {
        byte[] fileNameBytes = fileName.getBytes();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().deleteFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().deleteFile(this.connection.getSes()[0], fileNameBytes, fileNameBytes.length);
        }
        this.checkRet("createFile fileName " + fileName, ret, true);
    }

    public void importRSAPublicKey(RSAPublicKey rsaPublic, int index, boolean isSign) throws SdfSDKException {
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        String method = isSign ? "rsaImportSignpub" : "rsaImportEncpub";
        int ret = isSign ? this.connection.getSdfApi().RSAImportSignpub(this.connection.getSes()[0], index, rsaPublic) : this.connection.getSdfApi().RSAImportEncpub(this.connection.getSes()[0], index, rsaPublic);
        this.checkRet(method, ret, true);
        RSAPublicKey rsaPublicKey = new RSAPublicKey();
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        ret = isSign ? this.connection.getSdfApi().exportSignPublicKeyRSA(this.connection.getSes()[0], index, rsaPublicKey) : this.connection.getSdfApi().exportEncPublicKeyRSA(this.connection.getSes()[0], index, rsaPublicKey);
        this.checkRet("exportSignPublicKeyEcc", ret, true);
    }

    public void importRSAPrivateKey(RSAPrivateKey aPrivate, int index, byte[] password, boolean isSign) throws SdfSDKException {
        String method = isSign ? "rsaImportSignpri" : "rsaImportEncpri";
        this.connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = isSign ? this.connection.getSdfApi().RSAImportSignpri(this.connection.getSes()[0], index, aPrivate, 0) : this.connection.getSdfApi().RSAImportEncpri(this.connection.getSes()[0], index, aPrivate, 0);
        this.checkRet(method, ret, true);
    }

    static {
        PcieConnectionProviderImpl.getInstance();
    }
}

