/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie.pool;

import com.xdja.pcie.SDFAPI;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnection;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PciePooledObjectFactory
implements PooledObjectFactory<PcieConnection> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile SDFAPI sdfApi = new SDFAPI();
    private volatile long[] dev = new long[]{0L};

    PciePooledObjectFactory() {
        this.openDevice();
    }

    synchronized boolean isDeviceOpen() {
        return this.dev[0] != 0L;
    }

    synchronized void openDevice() {
        if (!this.isDeviceOpen()) {
            try {
                PcieSdfSDKUtils.openDevice(this.sdfApi, this.dev);
            }
            catch (SdfSDKException e) {
                this.logger.error("hsm pool init openDevice error", (Throwable)e);
            }
            this.logger.debug("openDevice dev = {} session = {}", (Object)this.dev[0]);
        } else {
            this.logger.error("hsm pool open device but dev={}", (Object)this.dev[0]);
        }
    }

    synchronized void closeDevice() {
        if (this.dev[0] != 0L) {
            try {
                PcieSdfSDKUtils.closeDevice(this.sdfApi, this.dev);
                this.logger.debug("closeDevice dev = {} session = {}", (Object)this.dev[0]);
            }
            catch (SdfSDKException e) {
                this.logger.error("hsm pool init closeDevice error", (Throwable)e);
            }
        }
        this.dev = new long[]{0L};
    }

    public PooledObject<PcieConnection> makeObject() throws Exception {
        if (this.dev[0] == 0L) {
            this.logger.error("make hsm connection device is not open! now open it!");
            this.openDevice();
        }
        PcieConnection connection = new PcieConnection(this.sdfApi, this.dev);
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<PcieConnection> pooledObject) throws Exception {
        PcieConnection connection = (PcieConnection)pooledObject.getObject();
        if (connection.isConnection()) {
            connection.close();
        }
    }

    public boolean validateObject(PooledObject<PcieConnection> pooledObject) {
        PcieConnection connection = (PcieConnection)pooledObject.getObject();
        return connection.isConnection();
    }

    public void activateObject(PooledObject<PcieConnection> pooledObject) throws Exception {
    }

    public void passivateObject(PooledObject<PcieConnection> pooledObject) throws Exception {
    }
}

