package com.xdja.pcie.base;

import java.io.Serializable;
import java.util.Arrays;

/**
 * ECC公钥数据实体定义
 * @author wyf
 *
 */
public class ECCPublicKey implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * ECC密钥最大位长
	 */
	public final static int ECC_MAX_BITS = 512;
	/**
	 * 公钥X、Y坐标最大长度
	 */
	public final static int ECC_MAX_LEN = (ECC_MAX_BITS + 7) / 8;
	
	/**
	 * 密钥位长
	 */
	private int bits;
	/**
	 * 公钥X坐标
	 */
	private byte[] x = new byte[ECC_MAX_LEN];
	/**
	 * 公钥Y坐标
	 */
	private byte[] y = new byte[ECC_MAX_LEN];
	
	public ECCPublicKey() {
		super();
	}

	public ECCPublicKey(int bits, byte[] x, byte[] y) {
		super();
		this.bits = bits;
		this.x = x;
		this.y = y;
	}

	/**
	 * 获得 bits
	 * @return bits 参见 {@linkplain #bits} 
	 */
	public int getBits() {
		return bits;
	}

	/**
	 * 设置 bits
	 * @param bits 参见 {@linkplain #bits}
	 */
	public void setBits(int bits) {
		this.bits = bits;
	}

	/**
	 * 获得 x
	 * @return x 参见 {@linkplain #x} 
	 */
	public byte[] getX() {
		return x;
	}

	/**
	 * 设置 x
	 * @param x 参见 {@linkplain #x}
	 */
	public void setX(byte[] x) {
		this.x = x;
	}

	/**
	 * 获得 y
	 * @return y 参见 {@linkplain #y} 
	 */
	public byte[] getY() {
		return y;
	}

	/**
	 * 设置 y
	 * @param y 参见 {@linkplain #y}
	 */
	public void setY(byte[] y) {
		this.y = y;
	}

	/**
	 * 获得 eccMaxBits
	 * @return eccMaxBits 参见 {@linkplain #ECC_MAX_BITS}
	 */
	public static int getEccMaxBits() {
		return ECC_MAX_BITS;
	}

	/**
	 * 获得 eccMaxLen
	 * @return eccMaxLen 参见 {@linkplain #ECC_MAX_LEN}
	 */
	public static int getEccMaxLen() {
		return ECC_MAX_LEN;
	}

	@Override
	public String toString() {
		return "ECCPublicKey [bits=" + bits + ", x=" + Arrays.toString(x) + ", y=" + Arrays.toString(y) + "]";
	}

}
