package com.xdja.pcie.base;

import java.io.Serializable;
import java.util.Arrays;

/**
 * ECC加密密钥对保护结构实体定义
 * @author wyf
 *
 */
public class EnvelopedKeyBlob implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 保护对称密钥的非对称算法标识
	 */
	private long ulAsymmAlgId;
	/**
	 * 对称算法标识
	 * <br/>备注：必须为ECB模式
	 */
	private long ulSymmAlgId;
	/**
	 * 对称密钥密文
	 */
	private ECCCipher ECCCipherBlob;
	/**
	 * 加密密钥对的公钥
	 */
	private ECCPublicKey publicKey;
	/**
	 * 加密密钥对的私钥密文，其有效长度为原文的(ulBits + 7)/8
	 * <br/>备注：私钥原文为结构为EccPrivateKey
	 */
	private byte[] cbEncryptedPrivKey = new byte[64];

	public EnvelopedKeyBlob() {
		super();
	}

	public EnvelopedKeyBlob(long ulAsymmAlgId, long ulSymmAlgId, ECCCipher ECCCipherBlob, ECCPublicKey publicKey,
							byte[] cbEncryptedPrivKey) {
		super();
		this.ulAsymmAlgId = ulAsymmAlgId;
		this.ulSymmAlgId = ulSymmAlgId;
		this.ECCCipherBlob = ECCCipherBlob;
		this.publicKey = publicKey;
		this.cbEncryptedPrivKey = cbEncryptedPrivKey;
	}

	/**
	 * 获得 ulAsymmAlgId
	 * @return ulAsymmAlgId 参见 {@linkplain #ulAsymmAlgId} 
	 */
	public long getUlAsymmAlgId() {
		return ulAsymmAlgId;
	}

	/**
	 * 设置 ulAsymmAlgId
	 * @param ulAsymmAlgId 参见 {@linkplain #ulAsymmAlgId}
	 */
	public void setUlAsymmAlgId(long ulAsymmAlgId) {
		this.ulAsymmAlgId = ulAsymmAlgId;
	}

	/**
	 * 获得 ulSymmAlgId
	 * @return ulSymmAlgId 参见 {@linkplain #ulSymmAlgId} 
	 */
	public long getUlSymmAlgId() {
		return ulSymmAlgId;
	}

	/**
	 * 设置 ulSymmAlgId
	 * @param ulSymmAlgId 参见 {@linkplain #ulSymmAlgId}
	 */
	public void setUlSymmAlgId(long ulSymmAlgId) {
		this.ulSymmAlgId = ulSymmAlgId;
	}

	/**
	 * 获得 ECCCipherBlob
	 * @return ECCCipherBlob 参见 {@linkplain #ECCCipherBlob}
	 */
	public ECCCipher getECCCipherBlob() {
		return ECCCipherBlob;
	}

	/**
	 * 设置 ECCCipherBlob
	 * @param ECCCipherBlob 参见 {@linkplain #ECCCipherBlob}
	 */
	public void setECCCipherBlob(ECCCipher ECCCipherBlob) {
		this.ECCCipherBlob = ECCCipherBlob;
	}

	/**
	 * 获得 publicKey
	 * @return publicKey 参见 {@linkplain #publicKey} 
	 */
	public ECCPublicKey getPublicKey() {
		return publicKey;
	}

	/**
	 * 设置 publicKey
	 * @param publicKey 参见 {@linkplain #publicKey}
	 */
	public void setPublicKey(ECCPublicKey publicKey) {
		this.publicKey = publicKey;
	}

	/**
	 * 获得 cbEncryptedPrivKey
	 * @return cbEncryptedPrivKey 参见 {@linkplain #cbEncryptedPrivKey} 
	 */
	public byte[] getCbEncryptedPrivKey() {
		return cbEncryptedPrivKey;
	}

	/**
	 * 设置 cbEncryptedPrivKey
	 * @param cbEncryptedPrivKey 参见 {@linkplain #cbEncryptedPrivKey}
	 */
	public void setCbEncryptedPrivKey(byte[] cbEncryptedPrivKey) {
		this.cbEncryptedPrivKey = cbEncryptedPrivKey;
	}

	@Override
	public String toString() {
		return "EnvelopedKeyBlob [ulAsymmAlgId=" + ulAsymmAlgId + ", ulSymmAlgId=" + ulSymmAlgId + ", ECCCipherBlob="
				+ ECCCipherBlob + ", publicKey=" + publicKey + ", cbEncryptedPrivKey="
				+ Arrays.toString(cbEncryptedPrivKey) + "]";
	}

}
