package com.xdja.pcie.sdf.jni;

import com.xdja.pcie.SDFAPI;
import com.xdja.pcie.base.*;
import com.xdja.pcie.sdf.jni.alg.AlgId;

import java.util.Arrays;
import java.util.Scanner;

public class SdfApiDemo {
    /**
     * 初始化
     * 1. 打开设备
     * 2. 初始化设备
     * 3. 打开 session
     *
     * @param sa
     * @param dev
     * @param ses
     * @return
     */
    public static int init(SDFAPI sa, long[] dev, long[] ses) {
        int ret = sa.openDevice(dev);
        if (ret != 0) {
            System.out.println(String.format("OpenDevice error, ret = %X", ret));
            return ret;
        }

        ret = sa.openSession(dev[0], ses);
        if (ret != 0) {
            System.out.println(String.format("OpenSession error, ret = %X", ret));
            return ret;
        }
        return 0;
    }

    public static void error(int ret, String message, SDFAPI sa, long[] dev, long[] ses) {
        if (ret != 0) {
            System.out.println(String.format(message + " error, ret = %X", ret));
            if (ses[0] != 0)
                sa.closeSession(ses[0]);

            if (dev[0] != 0)
                sa.closeDevice(dev[0]);
            System.exit(-1);
        }
    }

    private void sample() throws Exception {
        SDFAPI sa = new SDFAPI();
        long[] dev = {0}, ses = {0}, phKeyHandle = {0}, phAgreementHandle = {0};

        int ret;
        int uiKeyIndex = 10;
        int uiKekIndex = 10;
        String pwd = "xdja1234";
        byte[] pucPassword = pwd.getBytes();
        int uiPassword = 8;

        int uiKeyBits_ECC = 256;
        int uiKeyBits_SES = 128;

        //ECC签名公钥  ECC加密公钥
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        ECCPublicKey pucPublicKey_tmp = new ECCPublicKey();

        //响应方临时公钥结构
        ECCPublicKey pucResponsepublicKey = new ECCPublicKey();
        ECCPublicKey pucResponsepublicKey_tmp = new ECCPublicKey();

        //ECC私钥
        ECCPrivateKey pucPrivateKey = new ECCPrivateKey();
        //密钥密文
        ECCCipher pucKey = new ECCCipher();
        ECCCipher pucEncDateIn = new ECCCipher();
        ECCCipher pucEncDateOut = new ECCCipher();

        //发起方和响应方id值
        String pucSponaorID_t = "abcdefghijkl";
        byte[] pucSponaorID = pucSponaorID_t.getBytes();
        String pucResponseID_t = "ABCDEFGHIJKL";
        byte[] pucResponseID = pucResponseID_t.getBytes();
        int pucSponaorlen = 12;
        int pucResponselen = 12;

        //密钥密文
        byte[] pucKeyEcc = {0};
        int[] pucKeyEccLen = {0};

        //要加密的数据 和数据长度
        String pucDate_t = "asdfsdflrncefcjfasdfsdflrncefcjf";
        byte[] pucDate = pucDate_t.getBytes();
        int[] pucDateLen = {pucDate.length};
        ECCSignature pucSignature = new ECCSignature();

        //对称算法运算类函数缓冲区指针定义
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        byte[] pucDate_1 = new byte[1024];
        int[] pucEncDateLen = {1024};

        //杂凑算法
        byte[] PucID = {1, 1, 1, 1, 1, 1, 1, 1};
        int PucIDLen = 8;
        byte[] PucHash = new byte[1024];
        int[] PucHashLen = {1024};

        //文件操作类函数
        String pucFileName_t = "java_test.txt";
        byte[] pucFileName = pucFileName_t.getBytes();
        int pucFileNameLen = 13;
        int uiFileSize = 1024;
        int uiOffset = 5;
        int[] puiFileLength = {16};
        String pucBuffer_t = "123qweasdcxzvfr4";
        byte[] pucBuffer = pucBuffer_t.getBytes();
        byte[] pucBuffer_r = new byte[1024];

        try {
            ret = SdfApiDemo.init(sa, dev, ses);
            if (ret != 0) {
                System.out.println(String.format("init error, ret = %X", ret));
                return;
            }
            Scanner number = new Scanner(System.in);
            System.out.print("enter a number: ");//println换行；print不换行
            int id = number.nextInt();
            switch (id) {
                case 1: //获取设备信息
                    DeviceInfo devinfo = new DeviceInfo();
                    ret = sa.getDeviceInfo(ses[0], devinfo);
                    SdfApiDemo.error(ret, "getDeviceInfo is error", sa, dev, ses);
                    System.out.println(devinfo.toString());
                    break;
                case 2: //产生随机数
                    byte[] pucRandom = new byte[16];
                    int uiLength = 16;
                    ret = sa.generateRandom(ses[0], uiLength, pucRandom);
                    SdfApiDemo.error(ret, "generaterandom is error", sa, dev, ses);
                    System.out.println(Arrays.toString(pucRandom));
                    break;
                case 3: //获取私钥使用权限
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    SdfApiDemo.error(ret, "getprivateKeyAccessRight is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 4: //释放私钥使用权限
                    ret = sa.releasePrivateKeyAccessRight(ses[0], uiKeyIndex);
                    SdfApiDemo.error(ret, "getprivateKeyAccessRight is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 5: //导出RSA签名公钥
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 6: //导出RSA加密公钥
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 7: //产生RSA非对称密钥对并输出
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 8: //生成会话密钥并用内部RSA公钥加密输出
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 9: //生成会话密钥并用外部RSA公钥加密输出
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 10: //导人会话密钥并用内部RSA私钥解密
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 11: //基于RSA算法的数字信封转换
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 12: //导出ECC签名公钥
                    ret = sa.exportSignPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    SdfApiDemo.error(ret, "exportSignPublicKeyEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    break;
                case 13: //导出ECC加密公钥
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    SdfApiDemo.error(ret, "exportEncPublicKeyEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    break;
                case 14: //产生ECC非对称密钥对并输出
                    ret = sa.generateKeyPairECC(ses[0], AlgId.SGD_SM2, uiKeyBits_ECC, pucPublicKey, pucPrivateKey);
                    SdfApiDemo.error(ret, "exportEncPublicKeyEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    System.out.println(pucPrivateKey);
                    break;
                case 15: //生成会话密钥并用内部ECC公钥加密输出
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithIpkEcc is error", sa, dev, ses);
                    System.out.println(pucKey);
                    break;
                case 16: //生成会话密钥并用外部ECC公钥加密输出
                    //先导出公钥，导入，后续可改成从文件读取
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    sa.generateKeyWithEPKECC(ses[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithEpkEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    System.out.println(pucKey);
                    break;
                case 17: //导人会话密钥并用内部ECC私钥解密
                    //先生成会话密钥并用内部加密公钥加密输出。然后在调用内部私钥解密接口。
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.importKeyWithISKECC(ses[0], uiKeyIndex, pucKey, phKeyHandle);
                    SdfApiDemo.error(ret, "importKeyWithIskEcc is error", sa, dev, ses);
                    System.out.println(pucKey);
                    break;
                case 18: //生成密钥协商参数并输出
                    ret = sa.generateAgreementDataWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle);
                    SdfApiDemo.error(ret, "generateAgreementDataWithEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    System.out.println(pucPublicKey_tmp);
                    break;
                case 19: //计算会话密钥
                    //先生成密钥协商参数输出
                    ret = sa.generateAgreementDataWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle);
                    ret = sa.generateKeyWithECC(ses[0], pucResponseID, pucResponselen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle[0], phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithEcc is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 20: //产生协商数据并计算会话密钥
                    ret = sa.generateAgreementDataWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle);
                    ret = sa.generateAgreementDataAndKeyWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucResponseID, pucResponselen, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp,
                            pucResponsepublicKey, pucResponsepublicKey_tmp, phKeyHandle);
                    SdfApiDemo.error(ret, "generateAgreementDataAndKeyWithEcc is error", sa, dev, ses);
                    System.out.println(pucResponsepublicKey);
                    System.out.println(pucResponsepublicKey_tmp);
                    break;
                case 21: //基于ECC算法的数字信封转换
                    //ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucEncDateIn, phKeyHandle);
                    ret = sa.exchangeDigitEnvelopeBaseOnECC(ses[0], uiKeyIndex, AlgId.SGD_SM2, pucPublicKey, pucEncDateIn, pucEncDateOut);
                    SdfApiDemo.error(ret, "exchangeDigitEnvelopeOnEcc is error", sa, dev, ses);
                    System.out.println(pucEncDateOut);
                    break;
                case 22: //生成会话密钥并用密钥加密密钥加密输出
                    ret = sa.generateKeyWithKEK(ses[0], uiKeyBits_SES, AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen, phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithKek is error", sa, dev, ses);
                    System.out.println(pucKeyEcc.toString());
                    System.out.println(pucKeyEccLen[0]);
                    break;
                case 23: //导入会话密钥并用密钥加密密钥解密
                    ret = sa.generateKeyWithKEK(ses[0], uiKeyBits_SES, AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen, phKeyHandle);
                    ret = sa.importKeyWithKEK(ses[0], AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen[0], phKeyHandle);
                    SdfApiDemo.error(ret, "importKeyWithKek is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 24: //毁会话密钥
                    ret = sa.generateKeyWithKEK(ses[0], uiKeyBits_SES, AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen, phKeyHandle);
                    ret = sa.destroyKey(ses[0], phKeyHandle[0]);
                    SdfApiDemo.error(ret, "destroyKey is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 25: //外部公钥RSA运算
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 26: //内部公钥RSA运算
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 27: //内部私钥RSA运算
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
                case 28: //外部密钥ECC验证
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.internalSignECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    //System.out.println(pucDateLen[0]);
                    //System.out.println(pucDate);
                    //System.out.println(pucPublicKey);
                    //System.out.println(pucSignature);
                    ret = sa.externalVerifyECC(ses[0], AlgId.SGD_SM2, pucPublicKey, pucDate, pucDate.length, pucSignature);
                    SdfApiDemo.error(ret, "externalVerifyEcc is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 29: //内部密钥ECC签名
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.internalSignECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    SdfApiDemo.error(ret, "internalSignEcc is error", sa, dev, ses);
                    System.out.println(pucSignature);
                    break;
                case 30: //内部密钥ECC验证
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.internalSignECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    ret = sa.internalVerifyECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    SdfApiDemo.error(ret, "internalVerifyEcc is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 31: //外部密钥ECC加密
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.externalEncryptECC(ses[0], AlgId.SGD_SM2, pucPublicKey, pucDate, pucDate.length, pucEncDateOut);
                    SdfApiDemo.error(ret, "externalEncryptEcc is error", sa, dev, ses);
                    System.out.println(pucEncDateOut);
                    break;
                case 32: //对称加密
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.encrypt(ses[0], phKeyHandle[0], AlgId.SGD_SM1_ECB, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
                    SdfApiDemo.error(ret, "encrypt is error", sa, dev, ses);
                    System.out.println(new String(pucEncDate));
                    System.out.println(pucEncDateLen[0]);
                    break;
                case 33: //对称解密
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.encrypt(ses[0], phKeyHandle[0], AlgId.SGD_SM1_ECB, pucIV, pucDate, pucDateLen[0], pucEncDate, pucEncDateLen);
                    ret = sa.decrypt(ses[0], phKeyHandle[0], AlgId.SGD_SM1_ECB, pucIV, pucEncDate, pucEncDateLen[0], pucDate_1, pucDateLen);
                    SdfApiDemo.error(ret, "decrypt is error", sa, dev, ses);
                    System.out.println(new String(pucDate_1));
                    System.out.println(pucDateLen[0]);
                    break;
                case 34: //计算MAC
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.calculateMac(ses[0], phKeyHandle[0], AlgId.SGD_SM1_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
                    SdfApiDemo.error(ret, "calculateMac is error", sa, dev, ses);
                    System.out.println(new String(pucEncDate));
                    System.out.println(pucEncDateLen[0]);
                    break;
                case 35: //杂凑运算初始化
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.hashInit(ses[0], AlgId.SGD_SM3, pucPublicKey, PucID, PucIDLen);
                    SdfApiDemo.error(ret, "hashInit is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 36: //多包杂凑运算
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.hashInit(ses[0], AlgId.SGD_SM3, pucPublicKey, PucID, PucIDLen);
                    ret = sa.hashUpdate(ses[0], pucDate, pucDate.length);
                    SdfApiDemo.error(ret, "hashUpdate is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 37: //杂凑运算结束
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.hashInit(ses[0], AlgId.SGD_SM3, pucPublicKey, PucID, PucIDLen);
                    ret = sa.hashFinal(ses[0], PucHash, PucHashLen);
                    SdfApiDemo.error(ret, "hashFinal is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 38: //创建文件
                    ret = sa.createFile(ses[0], pucFileName, pucFileName.length, uiFileSize);
                    SdfApiDemo.error(ret, "createFile is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 39: //读取文件
                    ret = sa.readFile(ses[0], pucFileName, pucFileName.length, uiOffset, puiFileLength, pucBuffer_r);
                    SdfApiDemo.error(ret, "readFile is error", sa, dev, ses);
                    System.out.println(puiFileLength[0]);
                    System.out.println(new String(pucBuffer_r));
                    break;
                case 40: //写文件
                    ret = sa.writeFile(ses[0], pucFileName, pucFileNameLen, uiOffset, pucBuffer.length, pucBuffer);
                    SdfApiDemo.error(ret, "writeFile is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                case 41: //删除文件
                    ret = sa.deleteFile(ses[0], pucFileName, pucFileNameLen);
                    SdfApiDemo.error(ret, "deleteFile is error", sa, dev, ses);
                    System.out.println("success");
                    break;
                default:
                    System.out.println(String.format("unknown id value, plases input new id!"));
                    break;
            }
        } finally {
            if (ses[0] != 0l)
                sa.closeSession(ses[0]);

            if (dev[0] != 0)
                sa.closeDevice(dev[0]);
        }

    }
}
