package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.base.*;
import com.xdja.pki.gmssl.core.utils.GMSSLBCAeadUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.*;
import com.xdja.pcie.SDFAPI;
import com.xdja.pcie.sdf.jni.alg.AlgId;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnection;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;

public class PcieSdfSDK extends AbstractSdfSDK {

    static {
        PcieConnectionProviderImpl.getInstance();
    }

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private PcieConnection connection;

    @Override
    public void init() throws SdfSDKException {
//        //打开设备
//        int ret = sdfApi.openDevice(dev);
//        checkRet("openDevice", ret);
//        //打开 session
//        ret = sdfApi.openSession(dev[0], ses);
//        checkRet("openSession", ret);
    }

    @Override
    public void release() throws SdfSDKException {
//        int ret = sdfApi.closeSession(ses[0]);
//        checkRet("closeSession", ret);
//        ret = sdfApi.closeDevice(dev[0]);
//        checkRet("closeDevice", ret);
//        this.dev = new long[]{0};
//        this.ses = new long[]{0};
    }

    public void releaseConnection() {
        if (connection != null) {
//            HsmConnectionPool.getInstance().releaseConnection(connection);
            PcieConnectionProviderImpl.getInstance().releaseConnection(connection);
            connection = null;
        }
    }

    protected void checkRet(String method, int ret, boolean release) throws SdfSDKException {
        long dev = connection.getDev()[0];
        long ses = connection.getSes()[0];
        if (release || ret != 0) {
            releaseConnection();
        }
        PcieSdfSDKUtils.checkRet(method, ret, dev, ses);
    }

    @Override
    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        }
        checkRet("generateRandom uiLength " + uiLength, ret, true);
        return pucRandom;
    }

    @Override
    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        return generateKeyPairEcc(AlgId.SGD_SM2);
    }

    @Override
    public SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException {
        //ECC签名公钥  ECC加密公钥
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        ECCPrivateKey pucPrivateKey = new ECCPrivateKey();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyPairECC(connection.getSes()[0], algId, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyPairECC(connection.getSes()[0], algId, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        }
        checkRet("generateKeyPairEcc", ret, true);
//        byte[] k = GMSSLByteArrayUtils.filterByteArrayZeroInFoot()(pucPrivateKey.getK());
        logger.info("public key x :" + Hex.toHexString(pucPublicKey.getX()));
        logger.info("public key y :" + Hex.toHexString(pucPublicKey.getY()));
        logger.info("private key x :" + Hex.toHexString(pucPrivateKey.getK()));
        return new SdfECCKeyPair(
                SdfECCPublicKey.getInstanceFilterFoot(pucPublicKey.getX(), pucPublicKey.getY()),
                SdfECCPrivateKey.getInstanceFilterFoot(pucPrivateKey.getK())
        );
    }


    @Override
    public boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        boolean result = false;
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
//        connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
//        this.releasePrivateKeyAccessRight(connection, index);
        releaseConnection();
        if (ret == SdfApiCode.SDR_OK) {
            result = true;
        }
        return result;
    }

    public void releasePrivateKeyAccessRight(int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        checkRet("releasePrivateKeyAccessRight", ret, false);
    }

    private void getPrivateKeyAccessRight(PcieConnection connection, int index, byte[] password) throws SdfSDKException {
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
        // 私钥访问控制码错误
        if (ret == SdfApiCode.SDR_PRKRERR) {
            logger.debug("getPrivateKeyAccessRight fail password may be wrong, index={} password={}", index, new String(password));
            return;
        }
        checkRet("getPrivateKeyAccessRight", ret, false);
    }

    private void releasePrivateKeyAccessRight(PcieConnection connection, int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        checkRet("releasePrivateKeyAccessRight", ret, false);
    }

    public void importSM2PublicKey(PublicKey key, int index, boolean isSign) throws SdfSDKException {
        logger.info("导入SM2公钥开始");
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        logger.info("获取到connection");
        String method = isSign ? "sm2ImportSignpub" : "sm2ImportEncpub";

        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(logger, key);
        int ret;
        if (isSign) {
            ret = connection.getSdfApi().SM2ImportSignpub(connection.getSes()[0], index, pucPublicKey);
        } else {
            ret = connection.getSdfApi().SM2ImportEncpub(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet(method, ret, true);
        ECCPublicKey ecPublicKey_exp = new ECCPublicKey();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        if (isSign) {
            ret = connection.getSdfApi().exportSignPublicKeyECC(connection.getSes()[0], index, ecPublicKey_exp);
        } else {
            ret = connection.getSdfApi().exportEncPublicKeyECC(connection.getSes()[0], index, ecPublicKey_exp);
        }
        logger.info("导入成功");
        checkRet("exportSignPublicKeyEcc", ret, true);
    }

    public void importSM2PrivateKey(PrivateKey key, int index, byte[] password, boolean isSign) throws SdfSDKException {
        String method = isSign ? "sm2ImportSignpri" : "sm2ImportEncpri";
        ECCPrivateKey pucPrivateKey = PcieSdfSDKUtils.generateEccPrivateKey(logger, key);
        int ret;
        logger.info("导入SM2私钥开始");
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        logger.info("获取到connection");
        if (isSign) {
            ret = connection.getSdfApi().SM2ImportSignpri(connection.getSes()[0], index, pucPrivateKey, 0);
        } else {
            ret = connection.getSdfApi().SM2ImportEncpri(connection.getSes()[0], index, pucPrivateKey, 0);
        }
        logger.info("导入成功");
        checkRet(method, ret, true);
    }

    @Override
    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        ECCSignature pucSignature = new ECCSignature();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalSignECC(connection.getSes()[0], index, data, data.length, pucSignature);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            this.getPrivateKeyAccessRight(connection, index, password);
            ret = connection.getSdfApi().internalSignECC(connection.getSes()[0], index, data, data.length, pucSignature);
        }
//        this.releasePrivateKeyAccessRight(connection, index);
        checkRet("internalSignECC", ret, true);
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInFoot(pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInFoot(pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    @Override
    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyECC(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportSignPublicKeyECC(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportSignPublicKeyEcc", ret, true);
        return SdfECCPublicKey.getInstanceFilterFoot(pucPublicKey.getX(), pucPublicKey.getY());
    }

    @Override
    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        externalVerifyECC(publicKey, data, sdfECCSignature, "SM3WITHSM2");
    }

    @Override
    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException {
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfECCSignature.getS());
        ECCSignature pucSignature = new ECCSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(publicKey.getY());
        ECCPublicKey pucPublicKey = new ECCPublicKey(GMSSLX509Utils.ECC_KEY_BITS, x, y);
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int algId;
        if (signAlgName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (signAlgName.toUpperCase().contains("ECDSA")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support the signAlgName " + signAlgName);
        }
        int ret = connection.getSdfApi().externalVerifyECC(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().externalVerifyECC(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        }
        checkRet("externalVerifyECC", ret, true);
    }


    @Override
    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyECC(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportEncPublicKeyECC(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportEncPublicKeyEcc index " + index, ret, true);
        return SdfECCPublicKey.getInstanceFilterFoot(pucPublicKey.getX(), pucPublicKey.getY());
    }

    @Override
    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException {
        return externalEncryptECC(publicKey, data, "SM2");
    }

    @Override
    public SdfECCCipher externalEncryptECC(SdfECCPublicKey sdfECCPublicKey, byte[] data, String stdName) throws SdfSDKException {
        ECCCipher pucEncData = new ECCCipher();
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey.getX(), sdfECCPublicKey.getY());
        int algId;
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support stdName " + stdName);
        }
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().externalEncryptECC(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().externalEncryptECC(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        }
        checkRet("externalEncryptECC", ret, true);

//        GMSSLByteArrayUtils.printHexBinary(logger, "enc data x", pucEncData.getX());
//        GMSSLByteArrayUtils.printHexBinary(logger, "enc data y", pucEncData.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInFoot(pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInFoot(pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }


    @Override
    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        return internalDecryptECC(index, password, len, sdfECCCipher, "SM2");
    }

    @Override
    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException {
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfECCCipher.getX(),ECCPublicKey.ECC_MAX_LEN);
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfECCCipher.getY(),ECCPublicKey.ECC_MAX_LEN);
        ECCCipher pucEncData = new ECCCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = {len};
        int algId;
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support the stdName " + stdName);
        }
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalDecryptECC(connection.getSes()[0], algId, index, pucEncData, pucData, puiDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().internalDecryptECC(connection.getSes()[0], algId, index, pucEncData, pucData, puiDataLength);
        }
        checkRet("internalDecryptEcc index " + index + " password " + new String(password), ret, true);
        return pucData;
    }


    @Override
    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        this.destroyKey(keyHandle.getHandle());
        return keyHandle.getCipherKey();
    }

    @Override
    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    @Override
    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        int uiKeyBits_SES = 128;
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey);
        ECCCipher pucKey = new ECCCipher();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyWithEPKECC(connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyWithEPKECC(connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        }
        checkRet("generateKeyWithEPKECC", ret, false);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInFoot(pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInFoot(pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    @Override
    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        long[] phKeyHandle = {0};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfECCCipher.getY());
        ECCCipher pucKey = new ECCCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());

        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, uiIskIndex, password);
        int ret = connection.getSdfApi().importKeyWithISKECC(connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().importKeyWithISKECC(connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
//        this.releasePrivateKeyAccessRight(connection, uiIskIndex);
        checkRet("importKeyWithIskEcc index " + uiIskIndex + " password " + new String(password), ret, false);
        return phKeyHandle;
    }

    @Override
    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().ImportKey(connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().ImportKey(connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        }
        checkRet("importKey", ret, false);
        return phKeyHandle;
    }

    @Override
    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = {pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        int ret = connection.getSdfApi().encrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().encrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        }
        checkRet("encrypt", ret, false);
        return pucEncData;
    }

    @Override
    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = {pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        int ret = connection.getSdfApi().decrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().decrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        }
        checkRet("decrypt", ret, false);
        return pucData;
    }

    @Override
    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        if (connection != null) {
            int ret = connection.getSdfApi().destroyKey(connection.getSes()[0], phKeyHandle[0]);
            if (ret == SdfApiCode.SDR_COMMFAIL) {
                logger.error("destroyKey ret={} is SDR_COMMFAIL", ret);
            }
            checkRet("destroyKey", ret, true);
        }
    }

    @Override
    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        }
        checkRet("hashInit", ret, false);
    }

    @Override
    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        ECCPublicKey pucPublicKey = PcieSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey);
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        }
        checkRet("hashInit pucID " + new String(pucID), ret, false);
    }

    @Override
    public void hashUpdate(byte[] data) throws SdfSDKException {
        if (data.length == 0) {
            logger.debug("hashUpdate data length == 0");
            return;
        }
        int ret = connection.getSdfApi().hashUpdate(connection.getSes()[0], data, data.length);
        checkRet("hashUpdate", ret, false);
    }

    @Override
    public byte[] hashFinal(int digestLen) throws SdfSDKException {
        byte[] pucHash = new byte[digestLen];
        int[] pucHashLen = {pucHash.length};
        if (connection != null) {
            int ret = connection.getSdfApi().hashFinal(connection.getSes()[0], pucHash, pucHashLen);
            if (ret == SdfApiCode.SDR_COMMFAIL) {
                logger.error("hashFinal ret={} is SDR_COMMFAIL", ret);
            }
            checkRet("hashFinal digestLen " + digestLen, ret, true);
        }
        return pucHash;
    }

    @Override
    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int ret;
        int uiKeyBits_SES = 128;

        long[] phKeyHandle = {0};
        ECCCipher pucKey = new ECCCipher();

        //对称算法运算类函数缓冲区指针定义
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = {1024};

        //要加密的数据 和数据长度
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();

        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        ret = connection.getSdfApi().generateKeyWithIPKECC(connection.getSes()[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        checkRet("generateKeyWithIpkEcc", ret, false);
        ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        }

        checkRet("calculateMac uiKeyIndex " + uiKeyIndex, ret, true);
    }

    @Override
    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        int ret;
        byte[] mac = new byte[32];
        ret = connection.getSdfApi().SM3HMAC(connection.getSes()[0], dataIn, dataIn.length, key, key.length, mac);
        checkRet("sm3HmacDemo", ret, true);
        return mac;
    }

    public void getDeviceInfo() throws SdfSDKException {
        DeviceInfo devinfo = new DeviceInfo();
        int ret = connection.getSdfApi().getDeviceInfo(connection.getSes()[0], devinfo);
        checkRet("getDeviceInfo", ret, true);
        System.out.println(devinfo.toString());
    }


    @Override
    public SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException {
        RSAPublicKey pucPublicKey = new RSAPublicKey();

        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyRSA(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportSignPublicKeyRSA(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportSignPublicKeyRsa", ret, true);
        return SdfRSAPublicKey.getInstanceFilterFoot(pucPublicKey.getBits(), pucPublicKey.getM(), pucPublicKey.getE());
    }

    @Override
    public SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException {
        RSAPublicKey pucPublicKey = new RSAPublicKey();

        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyRSA(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportEncPublicKeyRSA(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportEncPublicKeyRsa index " + index, ret, true);
        return SdfRSAPublicKey.getInstanceFilterFoot(pucPublicKey.getBits(), pucPublicKey.getM(), pucPublicKey.getE());
    }

    @Override
    public SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException {
        RSAPublicKey rsaPublicKey = new RSAPublicKey();
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey();

        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyPairRSA(connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyPairRSA(connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        }
        checkRet("generateKeyPairRsa bits " + bits, ret, true);
        SdfRSAPrivateKey sdfRSAPrivateKey = new SdfRSAPrivateKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE(), rsaPrivateKey.getD(),
                rsaPrivateKey.getPrime(), rsaPrivateKey.getPexp(), rsaPrivateKey.getCoef());
        SdfRSAPublicKey sdfRSAPublicKey = new SdfRSAPublicKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE());
        return new SdfRsaKeyPair(sdfRSAPrivateKey, sdfRSAPublicKey);
    }

    @Override
    public byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException {
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = {1024};
        byte[] m = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfRSAPublicKey.getM(), 256);
        byte[] e = GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(sdfRSAPublicKey.getE(), 256);
        RSAPublicKey rsaPublicKey = new RSAPublicKey(sdfRSAPublicKey.getBits(), m, e);
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().externalPublicKeyOperationRSA(connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().externalPublicKeyOperationRSA(connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        checkRet("externalPublicKeyOperationRsa", ret, true);
        return pucDataOutPut;
    }

    @Override
    /**
     * data 必须按照PKCS1格式填充后再进行运算  256长度
     */
    public byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException {
        int[] puiDataOutPutLength = new int[2];
        SdfRSAPublicKey sdfRSAPublicKey = this.exportSignPublicKeyRsa(index);
        byte[] pucDataOutPut = new byte[sdfRSAPublicKey.getBits() / 8];
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalPrivateKeyOperationRSA(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().internalPrivateKeyOperationRSA(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        checkRet("internalPrivateKeyOperationRsa index " + index + " password " + new String(password), ret, true);
        return pucDataOutPut;
    }

    @Override
    public byte[] generateKeyWithEpkRsa(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public long[] generateKeyWithEpkRsaHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public SdfSymmetricKeyHandle generateKeyWithEpkRsaKeyHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public byte[] encryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public byte[] decryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public long[] importKeyWithKek(SdfAlgIdSymmetric uiAlgId, int uiKekIndex, byte[] pucKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public long[] importKeyWithIskRsa(int uiIskIndex, byte[] password, byte[] pucKey) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    @Override
    public byte[] generateKeyWithKek(int uiAlgId, int uiKekIndex) throws SdfSDKException {
        throw new SdfSDKException("not support");
    }

    /**
     * //TODO 待补充 PCIE相关文件操作注意事项
     */

    @Override
    public void createFile(String fileName, int fileSize) throws SdfSDKException {
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        byte[] fileNameBytes = fileName.getBytes();
        int ret = connection.getSdfApi().createFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length, fileSize);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().createFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length, fileSize);
        }
        checkRet("createFile fileName=" + fileName + " fileSize=" + fileSize, ret, true);
    }

    @Override
    public byte[] readFile(String fileName, int offset, int length) throws SdfSDKException {
        byte[] fileNameBytes = fileName.getBytes();
        byte[] buffer = new byte[length];
        int[] fileLength = new int[]{length};
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().readFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, fileLength, buffer);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().readFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, fileLength, buffer);
        }
        checkRet("readFile fileName=" + fileName + " offset=" + offset + " length=" + length, ret, true);
        if (fileLength[0] != length) {
            byte[] out = new byte[fileLength[0]];
            System.arraycopy(buffer, 0, out, 0, fileLength[0]);
            return out;
        }
        return buffer;
    }

    @Override
    public void writeFile(String fileName, int offset, byte[] context) throws SdfSDKException {
        byte[] fileNameBytes = fileName.getBytes();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().writeFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, context.length, context);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().writeFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length, offset, context.length, context);
        }
        checkRet("createFile fileName=" + fileName + " offset=" + offset + " contextLen=" + context.length, ret, true);
    }

    @Override
    public void deleteFile(String fileName) throws SdfSDKException {
        byte[] fileNameBytes = fileName.getBytes();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().deleteFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().deleteFile(connection.getSes()[0], fileNameBytes, fileNameBytes.length);
        }
        checkRet("createFile fileName " + fileName, ret, true);
    }

    /**
     * 导入RSA公钥
     *
     * @param rsaPublic RSA公钥
     * @param index     密钥索引
     * @param isSign    是否为签名公钥
     * @throws SdfSDKException
     */
    public void importRSAPublicKey(RSAPublicKey rsaPublic, int index, boolean isSign) throws SdfSDKException {
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        String method = isSign ? "rsaImportSignpub" : "rsaImportEncpub";
        int ret;
        if (isSign) {
            ret = connection.getSdfApi().RSAImportSignpub(connection.getSes()[0], index, rsaPublic);
        } else {
            ret = connection.getSdfApi().RSAImportEncpub(connection.getSes()[0], index, rsaPublic);
        }
        checkRet(method, ret, true);
        RSAPublicKey rsaPublicKey = new RSAPublicKey();
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        if (isSign) {
            ret = connection.getSdfApi().exportSignPublicKeyRSA(connection.getSes()[0], index, rsaPublicKey);
        } else {
            ret = connection.getSdfApi().exportEncPublicKeyRSA(connection.getSes()[0], index, rsaPublicKey);
        }
        checkRet("exportSignPublicKeyEcc", ret, true);
    }

    /**
     * 导入RSA私钥
     *
     * @param aPrivate SDF格式RSA私钥
     * @param index    导入的索引
     * @param isSign   是否为签名私钥
     * @throws SdfSDKException
     */
    public void importRSAPrivateKey(RSAPrivateKey aPrivate, int index, byte[] password, boolean isSign) throws SdfSDKException {
        String method = isSign ? "rsaImportSignpri" : "rsaImportEncpri";
        int ret;
        connection = PcieConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        if (isSign) {
            ret = connection.getSdfApi().RSAImportSignpri(connection.getSes()[0], index, aPrivate, 0);
        } else {
            ret = connection.getSdfApi().RSAImportEncpri(connection.getSes()[0], index, aPrivate, 0);
        }
        checkRet(method, ret, true);
    }

    @Override
    public SdfECCPublicKey exportSignPublicKeyEccEx(int index) throws SdfSDKException {
        return null;
    }

    @Override
    public SdfECCPublicKey exportEncPublicKeyEccEx(int index) throws SdfSDKException {
        return null;
    }

    @Override
    public SdfECCKeyPair generateKeyPairEccEx(int algId, int bits) throws SdfSDKException {
        return null;
    }

    @Override
    public void externalVerifyECCEx(SdfECCPublicKey key, byte[] data, SdfECCSignature pucSignature, SdfAlgIdAsymmetric algIdAsymmetric, int bits) throws SdfSDKException {

    }

    @Override
    public SdfECCSignature internalSignECCEx(int index, byte[] password, byte[] data, int bits) throws SdfSDKException {
        return null;
    }

    @Override
    public SdfECCCipher externalEncryptECCEx(SdfECCPublicKey publicKey, byte[] data, int bits, SdfAlgIdAsymmetric algIdAsymmetric) throws SdfSDKException {
        return null;
    }

    @Override
    public byte[] internalDecryptECCEx(int index, byte[] password, int len, SdfECCCipher pucEncData, int bits, SdfAlgIdAsymmetric algIdAsymmetric) throws SdfSDKException {
        return new byte[0];
    }
}

