package com.xdja.pki.gmssl.sdf.pcie.pool;

import com.xdja.pcie.SDFAPI;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName PcieConnection
 * @Description TODO
 * @Date 2020/5/18 20:03
 * @Author FengZhen
 */
public class PcieConnection {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SDFAPI sdfApi;
    private long[] dev;

    private volatile long[] ses = {0};
    private int id;
    private long startTime;

    public PcieConnection(SDFAPI sdfApi, long[] dev) throws SdfSDKException {
        this.sdfApi = sdfApi;
        this.dev = dev;
        PcieSdfSDKUtils.openSession(sdfApi, dev, ses);
    }

    public SDFAPI getSdfApi() {
        return sdfApi;
    }

    public long[] getDev() {
        return dev;
    }

    public long[] getSes() {
        return ses;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void reopen() throws SdfSDKException {
        PcieSdfSDKUtils.closeSession(sdfApi, dev, ses);
        this.ses = new long[]{0};
        PcieSdfSDKUtils.openSession(sdfApi, dev, ses);
    }

    public synchronized void close() throws SdfSDKException {
        PcieSdfSDKUtils.closeSession(sdfApi, dev, ses);
        this.ses = new long[]{0};
    }

    public String getDeviceInfo() throws SdfSDKException {
        return PcieSdfSDKUtils.getDeviceInfo(sdfApi, dev, ses);
    }

    public boolean isConnection() {
        try {
            PcieSdfSDKUtils.getDeviceInfo(sdfApi, dev, ses);
            return true;
        } catch (SdfSDKException e) {
            logger.debug("getDeviceInfo dev = {} session = {}, error={}", dev[0], ses[0], e);
            return false;
        }
    }

}
