package com.xdja.pcie.base;

import java.io.Serializable;
import java.util.Arrays;

/**
 * ECC签名数据实体定义
 * @author wyf
 *
 */
public class ECCSignature implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * 签名的r部分
	 */
	private byte[] r = new byte[ECCPublicKey.ECC_MAX_LEN];
	/**
	 * 签名的s部分
	 */
	private byte[] s = new byte[ECCPublicKey.ECC_MAX_LEN];

	public ECCSignature() {
		super();
	}

	public ECCSignature(byte[] r, byte[] s) {
		super();
		this.r = r;
		this.s = s;
	}

	/**
	 * 获得 r
	 * @return r 参见 {@linkplain #r} 
	 */
	public byte[] getR() {
		return r;
	}

	/**
	 * 设置 r
	 * @param r 参见 {@linkplain #r}
	 */
	public void setR(byte[] r) {
		this.r = r;
	}

	/**
	 * 获得 s
	 * @return s 参见 {@linkplain #s} 
	 */
	public byte[] getS() {
		return s;
	}

	/**
	 * 设置 s
	 * @param s 参见 {@linkplain #s}
	 */
	public void setS(byte[] s) {
		this.s = s;
	}

	@Override
	public String toString() {
		return "ECCSignature [r=" + Arrays.toString(r) + ", s=" + Arrays.toString(s) + "]";
	}

}
