package com.xdja.pcie.base;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.io.Serializable;
import java.util.Arrays;

/**
 * RSA私钥数据实体定义
 *
 * @author wyf
 */
public class RSAPrivateKey implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 模长
     */
    private int bits;
    /**
     * 模N
     */
    private byte[] m = new byte[RSAPublicKey.RSA_MAX_LEN];
    /**
     * 公钥指数
     */
    private byte[] e = new byte[RSAPublicKey.RSA_MAX_LEN];
    /**
     * 私钥指数
     */
    private byte[] d = new byte[RSAPublicKey.RSA_MAX_LEN];
    /**
     * 素数P和q
     */
    private byte[][] prime = new byte[2][RSAPublicKey.RSA_MAX_PLEN];
    /**
     * Dp和Dq
     */
    private byte[][] pexp = new byte[2][RSAPublicKey.RSA_MAX_PLEN];
    /**
     * 系数i
     */
    private byte[] coef = new byte[RSAPublicKey.RSA_MAX_PLEN];

    public RSAPrivateKey() {
        super();
    }

    public RSAPrivateKey(int bits, byte[] m, byte[] e, byte[] d, byte[][] prime, byte[][] pexp, byte[] coef) {
        super();
        this.bits = bits;
        this.m = m;
        this.e = e;
        this.d = d;
        this.prime = prime;
        this.pexp = pexp;
        this.coef = coef;
    }

    public static RSAPrivateKey getInstance(BCRSAPrivateCrtKey rsaPrivateCrtKey) {
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey();
        rsaPrivateKey.setBits(rsaPrivateCrtKey.getModulus().bitLength());
        rsaPrivateKey.setM(GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getModulus()), 256));
        rsaPrivateKey.setD(GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getPrivateExponent()), 256));
        rsaPrivateKey.setE(GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getPublicExponent()), 256));
        byte[] prime1 = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getPrimeP()), 128);
        byte[] prime2 = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getPrimeQ()), 128);
        byte[][] prime = new byte[2][128];
        prime[0] = prime1;
        prime[1] = prime2;
        byte[] pexp1 = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getPrimeExponentP()), 128);
        byte[] pexp2 = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getPrimeExponentQ()), 128);
        byte[][] pxep = new byte[2][128];
        pxep[0] = pexp1;
        pxep[1] = pexp2;
        rsaPrivateKey.setCoef(GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(rsaPrivateCrtKey.getCrtCoefficient()), 128));
        rsaPrivateKey.setPrime(prime);
        rsaPrivateKey.setPexp(pxep);
        return rsaPrivateKey;
    }

    /**
     * 获得 bits
     *
     * @return bits 参见 {@linkplain #bits}
     */
    public int getBits() {
        return bits;
    }

    /**
     * 设置 bits
     *
     * @param bits 参见 {@linkplain #bits}
     */
    public void setBits(int bits) {
        this.bits = bits;
    }

    /**
     * 获得 m
     *
     * @return m 参见 {@linkplain #m}
     */
    public byte[] getM() {
        return m;
    }

    /**
     * 设置 m
     *
     * @param m 参见 {@linkplain #m}
     */
    public void setM(byte[] m) {
        this.m = m;
    }

    /**
     * 获得 e
     *
     * @return e 参见 {@linkplain #e}
     */
    public byte[] getE() {
        return e;
    }

    /**
     * 设置 e
     *
     * @param e 参见 {@linkplain #e}
     */
    public void setE(byte[] e) {
        this.e = e;
    }

    /**
     * 获得 d
     *
     * @return d 参见 {@linkplain #d}
     */
    public byte[] getD() {
        return d;
    }

    /**
     * 设置 d
     *
     * @param d 参见 {@linkplain #d}
     */
    public void setD(byte[] d) {
        this.d = d;
    }

    /**
     * 获得 prime
     *
     * @return prime 参见 {@linkplain #prime}
     */
    public byte[][] getPrime() {
        return prime;
    }

    /**
     * 设置 prime
     *
     * @param prime 参见 {@linkplain #prime}
     */
    public void setPrime(byte[][] prime) {
        this.prime = prime;
    }

    /**
     * 获得 pexp
     *
     * @return pexp 参见 {@linkplain #pexp}
     */
    public byte[][] getPexp() {
        return pexp;
    }

    /**
     * 设置 pexp
     *
     * @param pexp 参见 {@linkplain #pexp}
     */
    public void setPexp(byte[][] pexp) {
        this.pexp = pexp;
    }

    /**
     * 获得 coef
     *
     * @return coef 参见 {@linkplain #coef}
     */
    public byte[] getCoef() {
        return coef;
    }

    /**
     * 设置 coef
     *
     * @param coef 参见 {@linkplain #coef}
     */
    public void setCoef(byte[] coef) {
        this.coef = coef;
    }

    public byte[] getPrime0() {
        return prime[0];
    }

    public byte[] getPrime1() {
        return prime[1];
    }

    public byte[] getPexp0() {
        return pexp[0];
    }

    public byte[] getPexp1() {
        return pexp[1];
    }

    @Override
    public String toString() {
        return "RSAPrivateKey [bits=" + bits + ", m=" + Hex.toHexString(m) + ", e=" + Hex.toHexString(e) + ", d="
                + Hex.toHexString(d) + ", prime=" + arrays(prime) + ", pexp=" + arrays(pexp)
                + ", coef=" + Hex.toHexString(coef) + "]";
    }

    public String arrays(byte[][] arrs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arrs.length; i++) {
            sb.append(i + " " + Hex.toHexString(arrs[i]) + " ");
        }
        return sb.toString();
    }

}
