/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pcie.base;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.io.Serializable;
import java.math.BigInteger;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class RSAPublicKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int RSA_MAX_BITS = 2048;
    public static final int RSA_MAX_LEN = 256;
    public static final int RSA_MAX_PBITS = 1024;
    public static final int RSA_MAX_PLEN = 128;
    private int bits;
    private byte[] m = new byte[256];
    private byte[] e = new byte[256];

    public RSAPublicKey() {
    }

    public RSAPublicKey(int bits, byte[] m, byte[] e) {
        this.bits = bits;
        this.m = m;
        this.e = e;
    }

    public static RSAPublicKey getInstance(BCRSAPrivateCrtKey rsaPrivateCrtKey) {
        RSAPublicKey rsaPublicKey = new RSAPublicKey();
        rsaPublicKey.setBits(rsaPrivateCrtKey.getModulus().bitLength());
        rsaPublicKey.setM(GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getModulus()), (int)256));
        rsaPublicKey.setE(GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPublicExponent()), (int)256));
        return rsaPublicKey;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getM() {
        return this.m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public byte[] getE() {
        return this.e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    public static int getRsaMaxBits() {
        return 2048;
    }

    public static int getRsaMaxLen() {
        return 256;
    }

    public static int getRsaMaxPbits() {
        return 1024;
    }

    public static int getRsaMaxPlen() {
        return 128;
    }

    public String toString() {
        return "RSAPublicKey [bits=" + this.bits + ", m=" + Hex.toHexString((byte[])this.m) + ", e=" + Hex.toHexString((byte[])this.e) + "]";
    }
}

