/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmConnection {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfApi sdfApi = new SdfApi();
    private long[] dev = new long[]{0L};
    private long[] ses = new long[]{0L};
    private int id;
    private long startTime;

    HsmConnection() throws SdfSDKException {
        this.init();
    }

    public SdfApi getSdfApi() {
        return this.sdfApi;
    }

    public long[] getDev() {
        return this.dev;
    }

    public long[] getSes() {
        return this.ses;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private void checkRet(String method, int ret) throws SdfSDKException {
        if (ret != 0) {
            this.logger.error("{} error! dev = {} session = {} ret = {} HEX = {} String = {}", new Object[]{method, this.dev[0], this.ses[0], ret, Integer.toHexString(ret), SdfApiCode.apiCodeToString((int)ret)});
            throw new SdfSDKException(method, ret);
        }
    }

    public void init() throws SdfSDKException {
        if (this.ses == null || this.ses.length == 0 || this.ses[0] == 0L) {
            String cfg = System.getenv("YUNHSMSDK_CONF");
            if (cfg == null) {
                this.logger.error("getenv(\"YUNHSMSDK_CONF\") return null, please set this env variable");
                throw new SdfSDKException("get system config error");
            }
            int ret = this.sdfApi.openDevice(this.dev);
            this.checkRet("openDevice", ret);
            ret = this.sdfApi.initialize(this.dev[0], cfg.getBytes());
            this.checkRet("initialize", ret);
            ret = this.sdfApi.openSession(this.dev[0], this.ses);
            this.checkRet("openSession", ret);
        }
    }

    public void release() throws SdfSDKException {
        this.logger.debug("release dev = {} session = {}", (Object)this.dev[0], (Object)this.ses[0]);
        int ret = this.sdfApi.closeSession(this.ses[0]);
        this.checkRet("closeSession", ret);
        ret = this.sdfApi.closeDevice(this.dev[0]);
        this.checkRet("closeDevice", ret);
        this.dev = new long[]{0L};
        this.ses = new long[]{0L};
    }
}

