/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.pki.gmssl.sdf.yunhsm.HsmConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmConnectionPool {
    private static Logger logger = LoggerFactory.getLogger(HsmConnectionPool.class);
    private static int POOL_MAX_LEN = 100;
    private static int POOL_LESS_LEN = POOL_MAX_LEN / 5;
    private static int FREE_LONG_TIME = 1000;
    private LinkedBlockingQueue<HsmConnection> freePool = new LinkedBlockingQueue(POOL_MAX_LEN);
    private LinkedBlockingQueue<HsmConnection> usedPool = new LinkedBlockingQueue(POOL_MAX_LEN);

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    private HsmConnectionPool() {
        logger.info("yunhsm connection pool init");
        for (int i = 0; i < POOL_MAX_LEN; ++i) {
            try {
                HsmConnection hsmConnection = new HsmConnection();
                hsmConnection.setId(i);
                hsmConnection.setStartTime(new Date().getTime());
                this.freePool.put(hsmConnection);
                continue;
            }
            catch (Exception e) {
                logger.error("init connection error", (Throwable)e);
            }
        }
    }

    public static HsmConnectionPool getInstance() {
        return HsmConnectionPoolHolder.instance;
    }

    public synchronized HsmConnection getConnection() {
        if (this.freePool.size() <= POOL_LESS_LEN && this.usedPool.size() > 0) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (HsmConnection conn : this.usedPool) {
                long now = new Date().getTime();
                if (now - conn.getStartTime() <= (long)FREE_LONG_TIME) continue;
                try {
                    HsmConnection take = this.usedPool.take();
                    list.add(take.getId());
                    this.freePool.put(take);
                }
                catch (InterruptedException e) {
                    logger.error("move connection error", (Throwable)e);
                }
            }
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String methodName = stackTrace[2].getMethodName();
        try {
            HsmConnection take = this.freePool.take();
            take.setStartTime(new Date().getTime());
            this.usedPool.put(take);
            return take;
        }
        catch (InterruptedException e) {
            logger.error("get connection error {}", (Object)methodName, (Object)e);
            return null;
        }
    }

    public synchronized void releaseConnection(HsmConnection hsmConnection) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String methodName = stackTrace[2].getMethodName();
        try {
            for (HsmConnection conn : this.usedPool) {
                if (conn.getId() != hsmConnection.getId()) continue;
                this.usedPool.remove(conn);
                this.freePool.put(hsmConnection);
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (HsmConnection conn : this.freePool) {
                list.add(conn.getId());
            }
        }
        catch (InterruptedException e) {
            logger.error("release connection error{}", (Object)methodName, (Object)e);
        }
    }

    static {
        if (HsmConnectionPool.isJUnitTest()) {
            POOL_MAX_LEN = 20;
            FREE_LONG_TIME = 1000;
        }
        HsmConnectionPool.getInstance();
    }

    private static class HsmConnectionPoolHolder {
        private static final HsmConnectionPool instance = new HsmConnectionPool();

        private HsmConnectionPoolHolder() {
        }
    }
}

