/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YumhsmSdfDemo {
    private static Logger logger = LoggerFactory.getLogger((String)YumhsmSdfDemo.class.getName());

    public static void main(String[] args) throws Exception {
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. random. gensm2key. getprikeyacc,sm1enc, exportenc. exportsign. sm2sign. sm2enc. sm4enc. sm3hash.  sm4mac");
            System.out.println("                    if use 'random' you can add length, Example: random 28, Default: 28");
            System.out.println("                    if use 'getprikeyacc' you can test getPrivateKeyAccess and releasePrivateKeyAccessRight");
            System.out.println("                    ......");
            return;
        }
        System.out.println("You want to test: " + args[0]);
        switch (args[0]) {
            case "all": {
                System.out.println("*************** random ***************");
                YumhsmSdfDemo.random(sdfSDK, args);
                System.out.println("*************** generateKeyPairEcc ***************");
                YumhsmSdfDemo.generateKeyPairEcc(sdfSDK);
                System.out.println("*************** getPrivateKeyAccess ***************");
                YumhsmSdfDemo.getPrivateKeyAccessRight(sdfSDK);
                System.out.println("*************** sm1EncDemo ***************");
                YumhsmSdfDemo.sm1EncDemo(sdfSDK);
                System.out.println("*************** sm2SignDemo ***************");
                YumhsmSdfDemo.sm2SignDemo(sdfSDK);
                System.out.println("*************** sm2EncDemo ***************");
                YumhsmSdfDemo.sm2EncDemo(sdfSDK);
                System.out.println("*************** sm3HashDemo ***************");
                YumhsmSdfDemo.sm3HashDemo(sdfSDK);
                System.out.println("*************** sm3HashDemoWithPublicKey ***************");
                YumhsmSdfDemo.sm3HashDemoWithPublicKey(sdfSDK);
                System.out.println("*************** sm4EncDemo ***************");
                YumhsmSdfDemo.sm4EncDemo(sdfSDK);
                System.out.println("*************** sm4MacDemo ***************");
                YumhsmSdfDemo.sm4MacDemo(sdfSDK);
                break;
            }
            case "random": {
                YumhsmSdfDemo.random(sdfSDK, args);
                break;
            }
            case "getprikeyacc": {
                YumhsmSdfDemo.getPrivateKeyAccessRight(sdfSDK);
                break;
            }
            case "sm1enc": {
                YumhsmSdfDemo.sm1EncDemo(sdfSDK);
                break;
            }
            case "exportsign": {
                YumhsmSdfDemo.exportSignKey(sdfSDK, args);
                break;
            }
            case "exportenc": {
                YumhsmSdfDemo.exportEncKey(sdfSDK, args);
                break;
            }
            case "gensm2key": {
                YumhsmSdfDemo.generateKeyPairEcc(sdfSDK);
                break;
            }
            case "sm2sign": {
                YumhsmSdfDemo.sm2SignDemo(sdfSDK);
                break;
            }
            case "sm2enc": {
                YumhsmSdfDemo.sm2EncDemo(sdfSDK);
                break;
            }
            case "sm3hash": {
                System.out.println("*************** sm3HashDemoWithPublicKey ***************");
                YumhsmSdfDemo.sm3HashDemoWithPublicKey(sdfSDK);
                System.out.println("*************** sm3HashDemo ***************");
                YumhsmSdfDemo.sm3HashDemo(sdfSDK);
                break;
            }
            case "sm4enc": {
                YumhsmSdfDemo.sm4EncDemo(sdfSDK);
                break;
            }
            case "sm4mac": {
                YumhsmSdfDemo.sm4MacDemo(sdfSDK);
                break;
            }
            default: {
                System.out.println("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\uff01");
            }
        }
    }

    private static void random(YunhsmSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        sdfSDK.init();
        int len = 28;
        if (args.length == 2) {
            len = Integer.valueOf(args[1]);
            logger.info("random number length is ", (Object)len);
        }
        byte[] out = sdfSDK.generateRandom(len);
        YumhsmSdfDemo.printHexBinary("generateRandom out", out);
        sdfSDK.release();
    }

    private static void generateKeyPairEcc(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        SdfECCKeyPair sdfECCKeyPair = sdfSDK.generateKeyPairEcc();
        byte[] x = sdfECCKeyPair.getSdfECCPublicKey().getX();
        byte[] y = sdfECCKeyPair.getSdfECCPublicKey().getY();
        YumhsmSdfDemo.printHexBinary("SdfECCPublicKey().getX()", x);
        YumhsmSdfDemo.printHexBinary("SdfECCPublicKey().getY()", y);
        sdfSDK.release();
    }

    private static void exportSignKey(YunhsmSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        logger.info("*************** exportSM2Key ***************");
        sdfSDK.init();
        int index = 26;
        try {
            index = Integer.valueOf(args[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(index);
        SdfECCPublicKey signPublicKeyEcc = sdfSDK.exportSignPublicKeyEcc(index);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"signPublicKeyEcc getX()", (byte[])signPublicKeyEcc.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"signPublicKeyEcc getY()", (byte[])signPublicKeyEcc.getY());
        sdfSDK.release();
    }

    private static void exportEncKey(YunhsmSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        logger.info("*************** exportSM2Key ***************");
        sdfSDK.init();
        int index = 26;
        try {
            index = Integer.valueOf(args[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(index);
        SdfECCPublicKey eccPublicKey = sdfSDK.exportEncPublicKeyEcc(index);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"eccPublicKey getX()", (byte[])eccPublicKey.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"eccPublicKey getY()", (byte[])eccPublicKey.getY());
        sdfSDK.release();
    }

    private static void getPrivateKeyAccessRight(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        logger.info("*************** getPrivateKeyAccessRight ***************");
        sdfSDK.getPrivateKeyAccessRight(20, "xdja1234".getBytes());
        logger.info("*************** releasePrivateKeyAccessRight ***************");
        sdfSDK.releasePrivateKeyAccessRight(20);
        sdfSDK.release();
    }

    public static void sm1EncDemo(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] cipher = GMSSLByteArrayUtils.hexDecode((String)"9203a010b50c4e3ca2897308a9d48c2e");
        logger.info(" sm1 CBC encrypt demo ");
        YumhsmSdfDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM1_CBC, key, data, cipher);
        logger.info(" sm1 ECB encrypt demo ");
        YumhsmSdfDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM1_ECB, key, data, cipher);
    }

    private static void sm2SignDemo(YunhsmSdfSDK sdfSDK) throws Exception {
        sdfSDK.init();
        SdfECCPublicKey sdfECCPublicKey = sdfSDK.exportSignPublicKeyEcc(20);
        byte[] in = "12345678123456781234567812345678".getBytes();
        YumhsmSdfDemo.printHexBinary("in", in);
        sdfSDK.getPrivateKeyAccessRight(20, "xdja1234".getBytes());
        SdfECCSignature signature = sdfSDK.internalSignECC(20, "xdja1234".getBytes(), in);
        YumhsmSdfDemo.printHexBinary("signature r", signature.getR());
        YumhsmSdfDemo.printHexBinary("signature s", signature.getS());
        sdfSDK.externalVerifyECC(sdfECCPublicKey, in, signature);
        sdfSDK.releasePrivateKeyAccessRight(20);
        logger.info("Yunhsm Verify Success !");
        sdfSDK.release();
    }

    private static void sm2EncDemo(YunhsmSdfSDK sdfSDK) throws SdfSDKException, IOException {
        sdfSDK.init();
        SdfECCPublicKey sdfECCPublicKey = sdfSDK.exportEncPublicKeyEcc(20);
        byte[] plain = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        YumhsmSdfDemo.printHexBinary("plain", plain);
        SdfECCCipher eccCipher = sdfSDK.externalEncryptECC(sdfECCPublicKey, plain);
        sdfSDK.getPrivateKeyAccessRight(20, "xdja1234".getBytes());
        byte[] decrypt = sdfSDK.internalDecryptECC(20, "xdja1234".getBytes(), eccCipher.getC().length, eccCipher);
        sdfSDK.releasePrivateKeyAccessRight(20);
        YumhsmSdfDemo.printHexBinary("decrypt", decrypt);
        if (Arrays.equals(plain, decrypt)) {
            logger.info("decrypt data is equals with plain data");
        } else {
            logger.error("decrypt data is not equals with plain data");
        }
        sdfSDK.release();
    }

    public static void sm3HashDemo(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        sdfSDK.hashUpdate("111".getBytes());
        byte[] out = sdfSDK.hashFinal();
        sdfSDK.release();
        YumhsmSdfDemo.printHexBinary("out", out);
    }

    public static void sm3HashDemoWithPublicKey(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        BigInteger SM2_ECC_XA = new BigInteger("09F9DF311E5421A150DD7D161E4BC5C672179FAD1833FC076BB08FF356F35020", 16);
        BigInteger SM2_ECC_YA = new BigInteger("CCEA490CE26775A52DC6EA718CC1AA600AED05FBF35E084A6632F6072DA9AD13", 16);
        byte[] xa = GMSSLByteArrayUtils.hexDecode((String)"09F9DF31 1E5421A1 50DD7D16 1E4BC5C6 72179FAD 1833FC07 6BB08FF3 56F35020");
        byte[] ya = GMSSLByteArrayUtils.hexDecode((String)"CCEA490C E26775A5 2DC6EA71 8CC1AA60 0AED05FB F35E084A 6632F607 2DA9AD13");
        byte[] ID_A = Strings.toByteArray((String)"1234567812345678");
        byte[] msg = Strings.toByteArray((String)"message digest");
        byte[] expecteds = GMSSLByteArrayUtils.hexDecode((String)"F0B43E94 BA45ACCA ACE692ED 534382EB 17E6AB5A 19CE7B31 F4486FDF C0D28640");
        YumhsmSdfDemo.printHexBinary("xa", xa);
        YumhsmSdfDemo.printHexBinary("ya", ya);
        YumhsmSdfDemo.printHexBinary("ID_A", ID_A);
        YumhsmSdfDemo.printHexBinary("message digest", msg);
        sdfSDK.init();
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3, ID_A, SdfECCPublicKey.getInstance((BigInteger)new BigInteger(xa), (BigInteger)new BigInteger(ya)));
        sdfSDK.hashUpdate(msg);
        byte[] actuals = sdfSDK.hashFinal();
        sdfSDK.release();
        YumhsmSdfDemo.printHexBinary("expecteds", expecteds);
        YumhsmSdfDemo.printHexBinary("actuals", actuals);
        if (Arrays.equals(expecteds, actuals)) {
            logger.info("expecteds data is equals with actuals data");
        } else {
            logger.error("expecteds data is not equals with actuals data");
        }
    }

    public static void sm4EncDemo(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] cipher = GMSSLByteArrayUtils.hexDecode((String)"681edf34d206965e86b3e94f536e4246");
        logger.info(" sm4 CBC encrypt demo ");
        YumhsmSdfDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM4_CBC, key, data, cipher);
        logger.info(" sm4 ECB encrypt demo ");
        YumhsmSdfDemo.symmetricEncDemo(sdfSDK, SdfAlgIdSymmetric.SGD_SM4_ECB, key, data, cipher);
    }

    public static void sm4MacDemo(YunhsmSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.init();
        sdfSDK.calculateMac(1);
        sdfSDK.release();
    }

    private static void symmetricEncDemo(YunhsmSdfSDK sdfSDK, SdfAlgIdSymmetric symmetric, byte[] key, byte[] data, byte[] cipher) throws SdfSDKException {
        sdfSDK.init();
        long[] handle = sdfSDK.importKey(key);
        byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"00000000000000000000000000000000");
        byte[] c = sdfSDK.encrypt(handle, symmetric, iv, data);
        YumhsmSdfDemo.printHexBinary("encrypt c", c);
        byte[] p = sdfSDK.decrypt(handle, symmetric, iv, c);
        YumhsmSdfDemo.printHexBinary("decrypt p", p);
        if (Arrays.equals(data, p)) {
            logger.info("decrypt data is equals with plain data");
        } else {
            logger.error("decrypt data is not equals with plain data");
        }
        if (Arrays.equals(cipher, c)) {
            logger.info("encrypt data is equals with expect cipher data");
        } else {
            logger.error("encrypt data is not equals with expect cipher data");
        }
        sdfSDK.release();
    }

    private static void printHexBinary(String message, byte[] data) {
        logger.info(message + " >> Hex len : " + data.length + " data : " + GMSSLByteArrayUtils.hexEncode((byte[])data));
    }
}

