/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.alg.AlgId;
import com.xdja.hsm.api.bean.DeviceInfo;
import com.xdja.hsm.api.bean.EccCipher;
import com.xdja.hsm.api.bean.EccPrivateKey;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.hsm.api.bean.EccSignature;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import com.xdja.pki.gmssl.sdf.bean.SdfSymmetricKeyHandle;
import com.xdja.pki.gmssl.sdf.yunhsm.HsmConnection;
import com.xdja.pki.gmssl.sdf.yunhsm.HsmConnectionPool;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunhsmSdfSDK
extends AbstractSdfSDK {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HsmConnection symmetricHsmConnection;
    private HsmConnection sm3HsmConnection;

    public void init() throws SdfSDKException {
    }

    public void release() throws SdfSDKException {
    }

    protected void checkRet(String method, int ret, HsmConnection connection) throws SdfSDKException {
        if (ret != 0) {
            this.logger.error("{} error! dev = {} session = {} ret = {} HEX={}:{}", new Object[]{method, connection.getDev()[0], connection.getSes()[0], ret, Integer.toHexString(ret), SdfApiCode.apiCodeToString((int)ret)});
            throw new SdfSDKException(method, ret);
        }
    }

    public void releaseConnection() {
        if (this.sm3HsmConnection != null) {
            HsmConnectionPool.getInstance().releaseConnection(this.sm3HsmConnection);
            this.sm3HsmConnection = null;
        }
        if (this.symmetricHsmConnection != null) {
            HsmConnectionPool.getInstance().releaseConnection(this.symmetricHsmConnection);
            this.symmetricHsmConnection = null;
        }
    }

    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("generateRandom", ret, connection);
        return pucRandom;
    }

    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], AlgId.SGD_SM2, 256, pucPublicKey, pucPrivateKey);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], AlgId.SGD_SM2, 256, pucPublicKey, pucPrivateKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("generateKeyPairEcc", ret, connection);
        return new SdfECCKeyPair(SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY()), SdfECCPrivateKey.getInstanceFilterHead((byte[])pucPrivateKey.getK()));
    }

    public void getPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
    }

    public void releasePrivateKeyAccessRight(int index) throws SdfSDKException {
    }

    private void getPrivateKeyAccessRight(HsmConnection connection, int index, byte[] password) throws SdfSDKException {
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
        this.checkRet("getPrivateKeyAccessRight", ret, connection);
    }

    private void releasePrivateKeyAccessRight(HsmConnection connection, int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        this.checkRet("releasePrivateKeyAccessRight", ret, connection);
    }

    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        EccSignature pucSignature = new EccSignature();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        }
        while (ret == 0x1000007) {
            this.getPrivateKeyAccessRight(connection, index, password);
            ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        }
        this.releasePrivateKeyAccessRight(connection, index);
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("internalSignECC", ret, connection);
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        HsmConnectionPool.getInstance().releaseConnection(connection);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportSignPublicKeyEcc", ret, connection);
        return SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCSignature.getS());
        EccSignature pucSignature = new EccSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])publicKey.getY());
        EccPublicKey pucPublicKey = new EccPublicKey(256, x, y);
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucSignature);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucSignature);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("externalVerifyECC", ret, connection);
    }

    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("exportEncPublicKeyEcc", ret, connection);
        return SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException {
        EccCipher pucEncData = new EccCipher();
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(this.logger, publicKey.getX(), publicKey.getY());
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucEncData);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucEncData);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("externalEncryptECC", ret, connection);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"enc data x", (byte[])pucEncData.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"enc data y", (byte[])pucEncData.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getY());
        EccCipher pucEncData = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = new int[]{len};
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        }
        while (ret == 0x1000007) {
            this.getPrivateKeyAccessRight(connection, index, password);
            ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        }
        this.releasePrivateKeyAccessRight(connection, index);
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("internalDecryptEcc", ret, connection);
        return pucData;
    }

    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        this.destroyKey(keyHandle.getHandle());
        return keyHandle.getCipherKey();
    }

    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        int ret;
        long[] phKeyHandle = new long[]{0L};
        int uiKeyBits_SES = 128;
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        EccCipher pucKey = new EccCipher();
        if (this.symmetricHsmConnection == null) {
            this.symmetricHsmConnection = HsmConnectionPool.getInstance().getConnection();
        }
        if ((ret = this.symmetricHsmConnection.getSdfApi().generateKeyWithEpkEcc(this.symmetricHsmConnection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle)) == 0x1000003) {
            this.symmetricHsmConnection.release();
            this.symmetricHsmConnection.init();
            ret = this.symmetricHsmConnection.getSdfApi().generateKeyWithEpkEcc(this.symmetricHsmConnection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        }
        this.checkRet("generateKeyWithEpkEcc", ret, this.symmetricHsmConnection);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"enc data x", (byte[])pucKey.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"enc data y", (byte[])pucKey.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getY());
        EccCipher pucKey = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        if (this.symmetricHsmConnection == null) {
            this.symmetricHsmConnection = HsmConnectionPool.getInstance().getConnection();
        }
        this.getPrivateKeyAccessRight(this.symmetricHsmConnection, uiIskIndex, password);
        int ret = this.symmetricHsmConnection.getSdfApi().importKeyWithIskEcc(this.symmetricHsmConnection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == 0x1000003) {
            this.symmetricHsmConnection.release();
            this.symmetricHsmConnection.init();
            ret = this.symmetricHsmConnection.getSdfApi().importKeyWithIskEcc(this.symmetricHsmConnection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
        while (ret == 0x1000007) {
            this.getPrivateKeyAccessRight(this.symmetricHsmConnection, uiIskIndex, password);
            ret = this.symmetricHsmConnection.getSdfApi().importKeyWithIskEcc(this.symmetricHsmConnection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
        this.releasePrivateKeyAccessRight(this.symmetricHsmConnection, uiIskIndex);
        this.checkRet("importKeyWithIskEcc", ret, this.symmetricHsmConnection);
        return phKeyHandle;
    }

    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        int ret;
        long[] phKeyHandle = new long[]{0L};
        if (this.symmetricHsmConnection == null) {
            this.symmetricHsmConnection = HsmConnectionPool.getInstance().getConnection();
        }
        if ((ret = this.symmetricHsmConnection.getSdfApi().importKey(this.symmetricHsmConnection.getSes()[0], pucKey, pucKey.length, phKeyHandle)) == 0x1000003) {
            this.symmetricHsmConnection.release();
            this.symmetricHsmConnection.init();
            ret = this.symmetricHsmConnection.getSdfApi().importKey(this.symmetricHsmConnection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        }
        this.checkRet("importKey", ret, this.symmetricHsmConnection);
        return phKeyHandle;
    }

    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        int ret;
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = new int[]{pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        if ((ret = this.symmetricHsmConnection.getSdfApi().encrypt(this.symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength)) == 0x1000003) {
            this.symmetricHsmConnection.release();
            this.symmetricHsmConnection.init();
            ret = this.symmetricHsmConnection.getSdfApi().encrypt(this.symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        }
        this.checkRet("encrypt", ret, this.symmetricHsmConnection);
        return pucEncData;
    }

    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        int ret;
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = new int[]{pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        if ((ret = this.symmetricHsmConnection.getSdfApi().decrypt(this.symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength)) == 0x1000003) {
            this.symmetricHsmConnection.release();
            this.symmetricHsmConnection.init();
            ret = this.symmetricHsmConnection.getSdfApi().decrypt(this.symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        }
        this.checkRet("decrypt", ret, this.symmetricHsmConnection);
        return pucData;
    }

    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        if (this.symmetricHsmConnection != null) {
            int ret = this.symmetricHsmConnection.getSdfApi().destroyKey(this.symmetricHsmConnection.getSes()[0], phKeyHandle[0]);
            if (ret == 0x1000003) {
                this.symmetricHsmConnection.release();
                this.symmetricHsmConnection.init();
                ret = this.symmetricHsmConnection.getSdfApi().destroyKey(this.symmetricHsmConnection.getSes()[0], phKeyHandle[0]);
            }
            HsmConnectionPool.getInstance().releaseConnection(this.symmetricHsmConnection);
            this.checkRet("destroyKey", ret, this.symmetricHsmConnection);
        }
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.sm3HsmConnection = HsmConnectionPool.getInstance().getConnection();
        int ret = this.sm3HsmConnection.getSdfApi().hashInit(this.sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        if (ret == 0x1000003) {
            this.sm3HsmConnection.release();
            this.sm3HsmConnection.init();
            ret = this.sm3HsmConnection.getSdfApi().hashInit(this.sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        }
        this.checkRet("hashInit", ret, this.sm3HsmConnection);
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        this.sm3HsmConnection = HsmConnectionPool.getInstance().getConnection();
        this.logger.info("hashInit session {}", (Object)this.sm3HsmConnection.getSes()[0]);
        int ret = this.sm3HsmConnection.getSdfApi().hashInit(this.sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        if (ret == 0x1000003) {
            this.sm3HsmConnection.release();
            this.sm3HsmConnection.init();
            ret = this.sm3HsmConnection.getSdfApi().hashInit(this.sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        }
        this.checkRet("hashInit", ret, this.sm3HsmConnection);
    }

    public void hashUpdate(byte[] data) throws SdfSDKException {
        this.logger.info("hashUpdate session {}", (Object)this.sm3HsmConnection.getSes()[0]);
        int ret = this.sm3HsmConnection.getSdfApi().hashUpdate(this.sm3HsmConnection.getSes()[0], data, data.length);
        this.checkRet("hashUpdate", ret, this.sm3HsmConnection);
    }

    public byte[] hashFinal() throws SdfSDKException {
        byte[] pucHash = new byte[32];
        int[] pucHashLen = new int[]{32};
        if (this.sm3HsmConnection != null) {
            this.logger.info("hashFinal session {}", (Object)this.sm3HsmConnection.getSes()[0]);
            int ret = this.sm3HsmConnection.getSdfApi().hashFinal(this.sm3HsmConnection.getSes()[0], pucHash, pucHashLen);
            if (ret == 0x1000003) {
                this.sm3HsmConnection.release();
                this.sm3HsmConnection.init();
                ret = this.sm3HsmConnection.getSdfApi().hashFinal(this.sm3HsmConnection.getSes()[0], pucHash, pucHashLen);
            }
            HsmConnectionPool.getInstance().releaseConnection(this.sm3HsmConnection);
            this.checkRet("hashFinal", ret, this.sm3HsmConnection);
        }
        return pucHash;
    }

    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int uiKeyBits_SES = 128;
        long[] phKeyHandle = new long[]{0L};
        EccCipher pucKey = new EccCipher();
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = new int[]{1024};
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyWithIpkEcc(connection.getSes()[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        this.checkRet("generateKeyWithIpkEcc", ret, connection);
        ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("calculateMac", ret, connection);
    }

    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        throw new SdfSDKException("yunhsm unsupport sm3 hmac");
    }

    public void getDeviceInfo() throws SdfSDKException {
        DeviceInfo devinfo = new DeviceInfo();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().getDeviceInfo(connection.getSes()[0], devinfo);
        if (ret == 0x1000003) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().getDeviceInfo(connection.getSes()[0], devinfo);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        this.checkRet("getDeviceInfo", ret, connection);
        this.logger.info(devinfo.toString());
    }

    static {
        HsmConnectionPool.getInstance();
    }
}

