/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.bean.EccPrivateKey;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import org.slf4j.Logger;

public class YunhsmSdfSDKUtils {
    public static EccPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        return YunhsmSdfSDKUtils.generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        logger.info("generateEccPublicKey");
        EccPublicKey pucPublicKey = new EccPublicKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])x), GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])y));
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"EccPublicKey x", (byte[])pucPublicKey.getX());
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"EccPublicKey y", (byte[])pucPublicKey.getY());
        return pucPublicKey;
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
        return YunhsmSdfSDKUtils.generateEccPrivateKey(logger, ecPrivateKey.getS().toByteArray());
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        logger.info("generateEccPrivateKey");
        EccPrivateKey pucPrivateKey = new EccPrivateKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])k));
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"pucPrivateKey k", (byte[])pucPrivateKey.getK());
        return pucPrivateKey;
    }

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(inputStream);
        return certificate.getPublicKey();
    }
}

