/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.bean.DeviceInfo;
import com.xdja.hsm.api.bean.EccPrivateKey;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunhsmSdfSDKUtils {
    private static Logger logger = LoggerFactory.getLogger(YunhsmSdfSDKUtils.class);

    public static String getConfigPath() {
        String cfgPath = System.getenv("YUNHSMSDK_CONF");
        if (cfgPath != null) {
            return cfgPath;
        }
        logger.debug("getenv(\"YUNHSMSDK_CONF\") return null, please set this env variable");
        String os = System.getProperty("os.name");
        if ("Linux".equals(os)) {
            return "/usr/local/yunhsmsdk/conf";
        }
        if (os.startsWith("Windows")) {
            return "C:\\Program Files\\yunhsmsdk\\conf";
        }
        return "";
    }

    public static void testConnection(String configPath) throws SdfSDKException {
        if (configPath == null) {
            configPath = YunhsmSdfSDKUtils.getConfigPath();
        }
        long[] dev = new long[]{0L};
        long[] ses = new long[]{0L};
        SdfApi sdfApi = new SdfApi();
        YunhsmSdfSDKUtils.openDevice(sdfApi, dev);
        YunhsmSdfSDKUtils.initialize(sdfApi, dev, configPath);
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, ses);
        YunhsmSdfSDKUtils.getDeviceInfo(sdfApi, dev, ses);
    }

    public static void checkRet(String method, int ret, long dev, long ses) throws SdfSDKException {
        if (ret != 0) {
            logger.error("{} error! dev = {} session = {} ret = {} HEX={}:{}", new Object[]{method, dev, ses, ret, Integer.toHexString(ret), SdfApiCode.apiCodeToString((int)ret)});
            throw new SdfSDKException(method, ret);
        }
    }

    public static void openDevice(SdfApi sdfApi, long[] dev) throws SdfSDKException {
        int ret = sdfApi.openDevice(dev);
        YunhsmSdfSDKUtils.checkRet("openDevice", ret, dev[0], 0L);
    }

    public static void initialize(SdfApi sdfApi, long[] dev, String configPath) throws SdfSDKException {
        int ret = sdfApi.initialize(dev[0], configPath.getBytes());
        YunhsmSdfSDKUtils.checkRet("initialize", ret, dev[0], 0L);
    }

    public static void openSession(SdfApi sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        int ret = sdfApi.openSession(dev[0], ses);
        YunhsmSdfSDKUtils.checkRet("openSession", ret, dev[0], ses[0]);
    }

    public static void closeSession(SdfApi sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        int ret = sdfApi.closeSession(ses[0]);
        YunhsmSdfSDKUtils.checkRet("closeSession", ret, dev[0], ses[0]);
    }

    public static void closeDevice(SdfApi sdfApi, long[] dev) throws SdfSDKException {
        int ret = sdfApi.closeDevice(dev[0]);
        YunhsmSdfSDKUtils.checkRet("closeDevice", ret, dev[0], 0L);
    }

    public static String getDeviceInfo(SdfApi sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        DeviceInfo deviceInfo = new DeviceInfo();
        int ret = sdfApi.getDeviceInfo(ses[0], deviceInfo);
        YunhsmSdfSDKUtils.checkRet("getDeviceInfo", ret, dev[0], ses[0]);
        return deviceInfo.toString();
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        return YunhsmSdfSDKUtils.generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        EccPublicKey pucPublicKey = new EccPublicKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])x), GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])y));
        return pucPublicKey;
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
        return YunhsmSdfSDKUtils.generateEccPrivateKey(logger, ecPrivateKey.getS().toByteArray());
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        logger.info("generateEccPrivateKey");
        EccPrivateKey pucPrivateKey = new EccPrivateKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])k));
        return pucPrivateKey;
    }
}

