/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.pool;

import com.xdja.hsm.api.SdfApi;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnection;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmPooledObjectFactory
implements PooledObjectFactory<HsmConnection> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile SdfApi sdfApi = new SdfApi();
    private volatile long[] dev = new long[]{0L};

    HsmPooledObjectFactory() {
        this.openDevice();
    }

    synchronized boolean isDeviceOpen() {
        return this.dev[0] != 0L;
    }

    synchronized void openDevice() {
        if (!this.isDeviceOpen()) {
            String configPath = YunhsmSdfSDKUtils.getConfigPath();
            if (configPath != null) {
                try {
                    YunhsmSdfSDKUtils.openDevice(this.sdfApi, this.dev);
                }
                catch (SdfSDKException e) {
                    this.logger.error("hsm pool init openDevice error", (Throwable)e);
                }
                try {
                    YunhsmSdfSDKUtils.initialize(this.sdfApi, this.dev, configPath);
                }
                catch (SdfSDKException e) {
                    this.logger.error("hsm pool init initialize error", (Throwable)e);
                }
                this.logger.debug("openDevice dev = {} session = {}", (Object)this.dev[0]);
            }
        } else {
            this.logger.error("hsm pool open device but dev={}", (Object)this.dev[0]);
        }
    }

    synchronized void closeDevice() {
        if (this.dev[0] != 0L) {
            try {
                YunhsmSdfSDKUtils.closeDevice(this.sdfApi, this.dev);
                this.logger.debug("closeDevice dev = {} session = {}", (Object)this.dev[0]);
            }
            catch (SdfSDKException e) {
                this.logger.error("hsm pool init closeDevice error", (Throwable)e);
            }
        }
        this.dev = new long[]{0L};
    }

    public PooledObject<HsmConnection> makeObject() throws Exception {
        if (this.dev[0] == 0L) {
            this.logger.error("make hsm connection device is not open! now open it!");
            this.openDevice();
        }
        HsmConnection connection = new HsmConnection(this.sdfApi, this.dev);
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<HsmConnection> pooledObject) throws Exception {
        HsmConnection connection = (HsmConnection)pooledObject.getObject();
        if (connection.isConnection()) {
            connection.close();
        }
    }

    public boolean validateObject(PooledObject<HsmConnection> pooledObject) {
        HsmConnection connection = (HsmConnection)pooledObject.getObject();
        return connection.isConnection();
    }

    public void activateObject(PooledObject<HsmConnection> pooledObject) throws Exception {
    }

    public void passivateObject(PooledObject<HsmConnection> pooledObject) throws Exception {
    }
}

