/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.alg.AlgId;
import com.xdja.hsm.api.bean.EccCipher;
import com.xdja.hsm.api.bean.EccPrivateKey;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.hsm.api.bean.EccSignature;
import com.xdja.hsm.api.bean.RsaPrivateKey;
import com.xdja.hsm.api.bean.RsaPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLBCAeadUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdAead;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRsaKeyPair;
import com.xdja.pki.gmssl.sdf.bean.SdfSymmetricKeyHandle;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnection;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunhsmSdfSDK
extends AbstractSdfSDK {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HsmConnection connection;

    public void init() throws SdfSDKException {
    }

    public void release() throws SdfSDKException {
    }

    protected void checkRet(String method, int ret, boolean release) throws SdfSDKException {
        long dev = this.connection.getDev()[0];
        long ses = this.connection.getSes()[0];
        if (release) {
            this.releaseConnection();
        }
        YunhsmSdfSDKUtils.checkRet(method, ret, dev, ses);
    }

    public void releaseConnection() {
        if (this.connection != null) {
            HsmConnectionProviderImpl.getInstance().releaseConnection(this.connection);
            this.connection = null;
        }
    }

    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateRandom(this.connection.getSes()[0], uiLength, pucRandom);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateRandom(this.connection.getSes()[0], uiLength, pucRandom);
        }
        this.checkRet("generateRandom uiLength " + uiLength, ret, true);
        return pucRandom;
    }

    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyPairEcc(this.connection.getSes()[0], AlgId.SGD_SM2, 256, pucPublicKey, pucPrivateKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyPairEcc(this.connection.getSes()[0], AlgId.SGD_SM2, 256, pucPublicKey, pucPrivateKey);
        }
        this.checkRet("generateKeyPairEcc", ret, true);
        return new SdfECCKeyPair(SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY()), SdfECCPrivateKey.getInstanceFilterHead((byte[])pucPrivateKey.getK()));
    }

    public SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyPairEcc(this.connection.getSes()[0], algId, 256, pucPublicKey, pucPrivateKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyPairEcc(this.connection.getSes()[0], algId, 256, pucPublicKey, pucPrivateKey);
        }
        this.checkRet("generateKeyPairEcc", ret, true);
        return new SdfECCKeyPair(SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY()), SdfECCPrivateKey.getInstanceFilterHead((byte[])pucPrivateKey.getK()));
    }

    public boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        boolean result = false;
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().getPrivateKeyAccessRight(this.connection.getSes()[0], index, password, password.length);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().getPrivateKeyAccessRight(this.connection.getSes()[0], index, password, password.length);
        }
        this.releaseConnection();
        if (ret == 0) {
            result = true;
        }
        return result;
    }

    private void getPrivateKeyAccessRight(HsmConnection connection, int index, byte[] password) throws SdfSDKException {
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == 0x1000003) {
            connection.reopen();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
        if (ret == 0x1000018) {
            this.logger.debug("getPrivateKeyAccessRight fail password may be wrong, index={} password={}", (Object)index, (Object)new String(password));
            return;
        }
        this.checkRet("getPrivateKeyAccessRight", ret, false);
    }

    private void releasePrivateKeyAccessRight(HsmConnection connection, int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == 0x1000003) {
            connection.reopen();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        this.checkRet("releasePrivateKeyAccessRight", ret, false);
    }

    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        EccSignature pucSignature = new EccSignature();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = this.connection.getSdfApi().internalSignEcc(this.connection.getSes()[0], index, data, data.length, pucSignature);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().internalSignEcc(this.connection.getSes()[0], index, data, data.length, pucSignature);
        }
        this.checkRet("internalSignECC", ret, true);
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportSignPublicKeyEcc(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportSignPublicKeyEcc(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportSignPublicKeyEcc", ret, true);
        return SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        this.externalVerifyECC(publicKey, data, sdfECCSignature, "SM3WITHSM2");
    }

    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException {
        int algId;
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCSignature.getS());
        EccSignature pucSignature = new EccSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])publicKey.getY());
        EccPublicKey pucPublicKey = new EccPublicKey(256, x, y);
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        if (signAlgName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (signAlgName.toUpperCase().contains("ECDSA")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support signAlgName " + signAlgName);
        }
        int ret = this.connection.getSdfApi().externalVerifyEcc(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().externalVerifyEcc(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        }
        this.checkRet("externalVerifyECC", ret, true);
    }

    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportEncPublicKeyEcc(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportEncPublicKeyEcc(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportEncPublicKeyEcc index " + index, ret, true);
        return SdfECCPublicKey.getInstanceFilterHead((byte[])pucPublicKey.getX(), (byte[])pucPublicKey.getY());
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException {
        return this.externalEncryptECC(publicKey, data, "SM2");
    }

    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data, String stdName) throws SdfSDKException {
        int algId;
        EccCipher pucEncData = new EccCipher();
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(this.logger, publicKey.getX(), publicKey.getY());
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support stdName " + stdName);
        }
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().externalEncryptEcc(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().externalEncryptEcc(this.connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        }
        this.checkRet("externalEncryptECC", ret, true);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        return this.internalDecryptECC(index, password, len, sdfECCCipher, "SM2");
    }

    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException {
        int algId;
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getY());
        EccCipher pucEncData = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = new int[]{len};
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support stdName " + stdName);
        }
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = this.connection.getSdfApi().internalDecryptEcc(this.connection.getSes()[0], index, algId, pucEncData, pucData, puiDataLength);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().internalDecryptEcc(this.connection.getSes()[0], index, algId, pucEncData, pucData, puiDataLength);
        }
        this.checkRet("internalDecryptEcc index " + index + " password " + new String(password), ret, true);
        return pucData;
    }

    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        this.destroyKey(keyHandle.getHandle());
        return keyHandle.getCipherKey();
    }

    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = this.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        int uiKeyBits_SES = 128;
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        EccCipher pucKey = new EccCipher();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyWithEpkEcc(this.connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyWithEpkEcc(this.connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        }
        this.checkRet("generateKeyWithEpkEcc", ret, false);
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])sdfECCCipher.getY());
        EccCipher pucKey = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, uiIskIndex, password);
        int ret = this.connection.getSdfApi().importKeyWithIskEcc(this.connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().importKeyWithIskEcc(this.connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
        this.checkRet("importKeyWithIskEcc index " + uiIskIndex + " password " + new String(password), ret, false);
        return phKeyHandle;
    }

    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().importKey(this.connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().importKey(this.connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        }
        this.checkRet("importKey", ret, false);
        return phKeyHandle;
    }

    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        int ret;
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = new int[]{pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        if ((ret = this.connection.getSdfApi().encrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength)) == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().encrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        }
        this.checkRet("encrypt", ret, false);
        return pucEncData;
    }

    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        int ret;
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = new int[]{pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        if ((ret = this.connection.getSdfApi().decrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength)) == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().decrypt(this.connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        }
        this.checkRet("decrypt", ret, false);
        return pucData;
    }

    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        if (this.connection != null) {
            int ret = this.connection.getSdfApi().destroyKey(this.connection.getSes()[0], phKeyHandle[0]);
            if (ret == 0x1000003) {
                this.connection.reopen();
                ret = this.connection.getSdfApi().destroyKey(this.connection.getSes()[0], phKeyHandle[0]);
            }
            this.checkRet("destroyKey", ret, true);
        }
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        }
        this.checkRet("hashInit", ret, false);
    }

    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(this.logger, sdfECCPublicKey);
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().hashInit(this.connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        }
        this.checkRet("hashInit pucID " + new String(pucID), ret, false);
    }

    public void hashUpdate(byte[] data) throws SdfSDKException {
        if (data.length == 0) {
            this.logger.debug("hashUpdate data length == 0");
            return;
        }
        int ret = this.connection.getSdfApi().hashUpdate(this.connection.getSes()[0], data, data.length);
        this.checkRet("hashUpdate", ret, false);
    }

    public byte[] hashFinal(int digestLen) throws SdfSDKException {
        byte[] pucHash = new byte[digestLen];
        int[] pucHashLen = new int[]{pucHash.length};
        if (this.connection != null) {
            int ret = this.connection.getSdfApi().hashFinal(this.connection.getSes()[0], pucHash, pucHashLen);
            if (ret == 0x1000003) {
                this.connection.reopen();
                ret = this.connection.getSdfApi().hashFinal(this.connection.getSes()[0], pucHash, pucHashLen);
            }
            this.checkRet("hashFinal digestLen " + digestLen, ret, true);
        }
        return pucHash;
    }

    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int uiKeyBits_SES = 128;
        long[] phKeyHandle = new long[]{0L};
        EccCipher pucKey = new EccCipher();
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = new int[]{1024};
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyWithIpkEcc(this.connection.getSes()[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        this.checkRet("generateKeyWithIpkEcc", ret, false);
        ret = this.connection.getSdfApi().calculateMac(this.connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().calculateMac(this.connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        }
        this.checkRet("calculateMac uiKeyIndex " + uiKeyIndex, ret, true);
    }

    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        throw new SdfSDKException("yunhsm unsupport sm3 hmac");
    }

    public void testConnect() throws SdfSDKException {
        YunhsmSdfSDKUtils.testConnection(null);
    }

    public void testConnect(String configPath) throws SdfSDKException {
        YunhsmSdfSDKUtils.testConnection(configPath);
    }

    public SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException {
        RsaPublicKey pucPublicKey = new RsaPublicKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportSignPublicKeyRsa(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportSignPublicKeyRsa(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportSignPublicKeyRsa", ret, true);
        return SdfRSAPublicKey.getInstanceFilterHead((int)pucPublicKey.getBits(), (byte[])pucPublicKey.getM(), (byte[])pucPublicKey.getE());
    }

    public SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException {
        RsaPublicKey pucPublicKey = new RsaPublicKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().exportEncPublicKeyRsa(this.connection.getSes()[0], index, pucPublicKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().exportEncPublicKeyRsa(this.connection.getSes()[0], index, pucPublicKey);
        }
        this.checkRet("exportEncPublicKeyRsa index " + index, ret, true);
        return SdfRSAPublicKey.getInstanceFilterHead((int)pucPublicKey.getBits(), (byte[])pucPublicKey.getM(), (byte[])pucPublicKey.getE());
    }

    public SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException {
        RsaPublicKey rsaPublicKey = new RsaPublicKey();
        RsaPrivateKey rsaPrivateKey = new RsaPrivateKey();
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyPairRsa(this.connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyPairRsa(this.connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        }
        this.checkRet("generateKeyPairRsa bits " + bits, ret, true);
        SdfRSAPrivateKey sdfRSAPrivateKey = new SdfRSAPrivateKey(rsaPrivateKey.getBits(), rsaPrivateKey.getM(), rsaPrivateKey.getE(), rsaPrivateKey.getD(), rsaPrivateKey.getPrime(), rsaPrivateKey.getPexp(), rsaPrivateKey.getCoef());
        SdfRSAPublicKey sdfRSAPublicKey = new SdfRSAPublicKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE());
        return new SdfRsaKeyPair(sdfRSAPrivateKey, sdfRSAPublicKey);
    }

    public byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException {
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = new int[]{bitLen};
        RsaPublicKey rsaPublicKey = YunhsmSdfSDKUtils.generateRsaPublicKey(this.logger, sdfRSAPublicKey);
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().externalPublicKeyOperationRsa(this.connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().externalPublicKeyOperationRsa(this.connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        this.checkRet("externalPublicKeyOperationRsa", ret, true);
        return pucDataOutPut;
    }

    public byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = this.exportSignPublicKeyRsa(index);
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = new int[]{bitLen};
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, index, password);
        int ret = this.connection.getSdfApi().internalPrivateKeyOperationRsa(this.connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().internalPrivateKeyOperationRsa(this.connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        this.checkRet("internalPrivateKeyOperationRsa index " + index + " password " + new String(password), ret, true);
        return pucDataOutPut;
    }

    public byte[] encryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException {
        int ret;
        byte[] pucTag = new byte[tagLen];
        byte[] pucEncData = new byte[data.length];
        int[] puiEncDataLength = new int[]{pucEncData.length};
        if (null == nonce) {
            nonce = new byte[]{};
        }
        if (null == aad) {
            aad = new byte[]{};
        }
        if ((ret = this.connection.getSdfApi().encryptAead(this.connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(), nonce, nonce.length, aad, aad.length, data, data.length, pucTag, pucTag.length, pucEncData, puiEncDataLength)) == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().encryptAead(this.connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(), nonce, nonce.length, aad, aad.length, data, data.length, pucTag, pucTag.length, pucEncData, puiEncDataLength);
        }
        this.checkRet("encrypt aead", ret, true);
        return GMSSLBCAeadUtils.pieceCipherTag((byte[])pucEncData, (byte[])pucTag);
    }

    public byte[] decryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException {
        int ret;
        byte[][] cipher = GMSSLBCAeadUtils.splitCipherTag((byte[])enc, (int)tagLen);
        byte[] pucEncData = cipher[0];
        byte[] pucTag = cipher[1];
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = new int[]{pucData.length};
        if (null == nonce) {
            nonce = new byte[]{};
        }
        if (null == aad) {
            aad = new byte[]{};
        }
        if ((ret = this.connection.getSdfApi().decryptAead(this.connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(), nonce, nonce.length, aad, aad.length, pucEncData, pucEncData.length, pucTag, pucTag.length, pucData, puiDataLength)) == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().decryptAead(this.connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(), nonce, nonce.length, aad, aad.length, pucEncData, pucEncData.length, pucTag, pucTag.length, pucData, puiDataLength);
        }
        this.checkRet("encrypt aead", ret, true);
        return pucData;
    }

    public long[] importKeyWithKek(SdfAlgIdSymmetric uiAlgId, int uiKekIndex, byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().importKeyWithKek(this.connection.getSes()[0], uiAlgId.getId(), uiKekIndex, pucKey, pucKey.length, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().importKeyWithKek(this.connection.getSes()[0], uiAlgId.getId(), uiKekIndex, pucKey, pucKey.length, phKeyHandle);
        }
        this.checkRet("importKeyWithKek", ret, false);
        return phKeyHandle;
    }

    public byte[] generateKeyWithEpkRsa(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle sdfSymmetricKeyHandle = this.generateKeyWithEpkRsaKeyHandle(sdfRSAPublicKey);
        this.destroyKey(sdfSymmetricKeyHandle.getHandle());
        return sdfSymmetricKeyHandle.getRsaCipherKey();
    }

    public long[] generateKeyWithEpkRsaHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle sdfSymmetricKeyHandle = this.generateKeyWithEpkRsaKeyHandle(sdfRSAPublicKey);
        return sdfSymmetricKeyHandle.getHandle();
    }

    public SdfSymmetricKeyHandle generateKeyWithEpkRsaKeyHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        int uiKeyBits_SES = 128;
        RsaPublicKey rsaPublicKey = YunhsmSdfSDKUtils.generateRsaPublicKey(this.logger, sdfRSAPublicKey);
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucKey = new byte[bitLen];
        int[] puiKeyLength = new int[]{bitLen};
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyWithEpkRsa(this.connection.getSes()[0], uiKeyBits_SES, rsaPublicKey, pucKey, puiKeyLength, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyWithEpkRsa(this.connection.getSes()[0], uiKeyBits_SES, rsaPublicKey, pucKey, puiKeyLength, phKeyHandle);
        }
        this.checkRet("generateKeyWithEpkRsa", ret, false);
        return new SdfSymmetricKeyHandle(pucKey, phKeyHandle);
    }

    public long[] importKeyWithIskRsa(int uiIskIndex, byte[] password, byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(this.connection, uiIskIndex, password);
        int ret = this.connection.getSdfApi().importKeyWithIskRsa(this.connection.getSes()[0], uiIskIndex, pucKey, pucKey.length, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().importKeyWithIskRsa(this.connection.getSes()[0], uiIskIndex, pucKey, pucKey.length, phKeyHandle);
        }
        this.checkRet("importKeyWithIskRsa index " + uiIskIndex + " password " + new String(password), ret, false);
        return phKeyHandle;
    }

    public byte[] generateKeyWithKek(int uiAlgId, int uiKekIndex) throws SdfSDKException {
        long[] phKeyHandle = new long[]{0L};
        int uiKeyBits_SES = 128;
        byte[] pucKey = new byte[uiKeyBits_SES / 8];
        int[] puiKeyLength = new int[]{uiKeyBits_SES / 8};
        this.connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = this.connection.getSdfApi().generateKeyWithKek(this.connection.getSes()[0], uiKeyBits_SES, uiAlgId, uiKekIndex, pucKey, puiKeyLength, phKeyHandle);
        if (ret == 0x1000003) {
            this.connection.reopen();
            ret = this.connection.getSdfApi().generateKeyWithKek(this.connection.getSes()[0], uiKeyBits_SES, uiAlgId, uiKekIndex, pucKey, puiKeyLength, phKeyHandle);
        }
        this.checkRet("generateKeyWithKek index " + uiKekIndex, ret, false);
        return pucKey;
    }

    static {
        HsmConnectionProviderImpl.getInstance();
    }
}

